package com.xunlei.niux.manager.web.task.user;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Random;
import com.xunlei.common.util.StringTools;


public class UserTask {

	static String[] digitletters = new String[] { "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C",
		"D", "E", "F", "G", "H",  "J", "K", "M", "N", "P", "Q", "R", "S", "T",
	    "W", "X", "Y", "Z" };
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		setPassword();
	}
	
	
	/**
	 * 修改玩家的密码，生成随机的十位
	 */	
	private static void setPassword(){
		   Connection conn = null;
		   Connection ctconn = null;
		   Statement stmt = null;
		   PreparedStatement ctstmt = null;
		   ResultSet rs = null;
		   try{
			   conn = ManagerConnUtil.getBackConnection();
			   ctconn = ManagerConnUtil.getBackConnection();
			   stmt =conn.createStatement();		
			   String sql = "select UserLogNo from users";
			   rs = stmt.executeQuery(sql);
			   String updatesql = "update users set UserPassword=? where UserLogNo=?";
			   while(rs.next()){
				    String UserLogNo = rs.getString("UserLogNo");
				    String password = getRandomCode(10);					
					String newPassword = StringTools.encrypt(password);
					System.out.println(newPassword);
					System.out.println("user:"+UserLogNo+",oldPassword:"+password+",newPassword:"+newPassword);
				    ctstmt = ctconn.prepareStatement(updatesql);
				    ctstmt.setString(1, newPassword);
				    ctstmt.setString(2, UserLogNo);
	            	ctstmt.execute();
			   }
	   }catch(Exception e){
		   e.printStackTrace();
	   }finally{
		   try{
			   if(ctstmt != null){//关闭连接
				  ctstmt.close();
				  ctstmt = null;
			   }
			   if(rs != null){
				   rs.close();
				   rs = null;
			   }
			   if(stmt != null){
				   stmt.close();
				   stmt = null;
			   }
			   if(ctconn != null){
				   ctconn.close();
				   ctconn = null;
			   }
			   if(conn != null){
				   conn.close();
				   conn = null;
			   }
		   }catch(Exception e){
			   e.printStackTrace();
		   }
	   }						
	}
	
	
    /**
     * 获得随机码
     * @param randomLen
     * @return
     */
    private static String  getRandomCode(int randomLen){
    	Random rand = new Random();        
    	String code = "";
    	for(int i=0;i<randomLen;i++){
    		int index = rand.nextInt(28);
    		code+=digitletters[index];
    	}
    	return code;
    }
    

}
