package com.xunlei.niux.manager.web.task.spreadinfo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import com.xunlei.niux.manager.web.vo.ConnUtil;

public class SpreadTask {
	
	public static void main(String[] args) {
		System.out.println("SpreadTask start...........");
		update();
		System.out.println("SpreadTask end...........");
	}
	
	
	private static  void update(){
		Connection conn = null;
		Connection uconn = null;
		Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try{
			conn = ConnUtil.getConn();
			uconn = ConnUtil.getConn();
			stmt = conn.createStatement();
			String sql = "select * from spreadinfo where  flatno='官网渠道';";
			String updatesql = "update spreadinfo set jumpurl=? where seqid=?";
			pstmt = uconn.prepareStatement(updatesql);
			rs = stmt.executeQuery(sql);
			while(rs.next()){
				String jumpurl = rs.getString("jumpurl");
				if(jumpurl.indexOf("advNo")!=-1)continue;
				long seqid = rs.getLong("seqId");
				String advNo = rs.getString("advNo");
				String jumpUrl = findJumpUrl(jumpurl,advNo);
				System.out.println("advNo:"+advNo+",jumpurl:"+jumpurl);
				pstmt.setString(1,jumpUrl);
				pstmt.setLong(2, seqid);
				pstmt.execute();
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(uconn != null){
					uconn.close();
					uconn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	private static String findJumpUrl(String jumpurl,String advNo) {      
        String advNoStr = "advNo=" + advNo;
        if (!jumpurl.contains(advNoStr)) {
            if (jumpurl.endsWith("/")) {
                jumpurl += "?" + advNoStr;
            } else if (jumpurl.endsWith("?")) {
                jumpurl += advNoStr;
            } else if (!jumpurl.contains("?")) {
                jumpurl += "?" + advNoStr;
            } else {
                jumpurl += "&" + advNoStr;
            }
           return jumpurl;
        }
        return null;
    }
}
