package com.xunlei.niux.manager.web.task.spreadinfo;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import com.xunlei.niux.manager.web.task.AbstractBaseTask;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.util.ShortUrlCreater;
import com.xunlei.niux.manager.web.vo.ConnUtil;

public class GamesSpreadInfoTask extends AbstractBaseTask {
	private static final String DOMAIN = "http://jump.niu.xunlei.com:8080/";
	private static final String PATH = "/usr/local/templatedata/formal/niuofficial/gamedata/spreadinfo/";
	public static void main(String[] args) {
		System.out.println("=========getGames start=========");
		 List<GameDTO> games = getGames();
		System.out.println("=========getGames end=========");
		makeJs(games);
		System.out.println("=========getGames end=========");
		close(games);
		 System.out.println("=========close end=========");
	}
	
	
	private static String getGameId(List<GameDTO> games,String gameName){
		for(GameDTO game:games){
			if(game.getGameName().trim().equals(gameName.trim())){
				return game.getGameId();
			}
		}
		return null;
	}
	
	private static void makeJs(List<GameDTO> games){
		String sql = "select * from spreadinfo where inputTime='2015-02-03 14:53:25'";
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		try{
			conn = ConnUtil.getConn();
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			while(rs.next()){
				String advNo = rs.getString("advNo");
				String spreadTab = rs.getString("spreadTab");
				spreadTab = spreadTab.substring(0,spreadTab.length()-2);
				String jsonStr = "var advNo='"+advNo+"';";	
				String gameId = getGameId(games,spreadTab);
				System.out.println("gameid:"+gameId);
				File file = FileUtil.createFile(PATH,gameId+".js");
				FileUtil.writeByChar(file, jsonStr);		
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	private static void close(List<GameDTO> games){
		if(games != null){
			games.clear();
			games = null;
		}
	}
	
	private static  List<GameDTO> getGames(){
		Connection conn = null;
		Statement stmt =null;
		ResultSet rs = null;
		List<GameDTO> list  = new ArrayList<GameDTO>();
		try{
			conn = ConnUtil.getConn();
			String sql = "select * from games where status=1 and clientType=0";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			while(rs.next()){
				GameDTO game = new GameDTO();
				game.setGameId(rs.getString("gameId"));
				game.setGameName(rs.getString("gameName"));
				game.setUrl(rs.getString("officialWebSite"));
				list.add(game);
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}			
		}
		return list;
	}
	
	private static void addGamesSpreadInfo(List<GameDTO> games){
		Connection conn = null;
		PreparedStatement pstmt = null;
		try{
			conn = ConnUtil.getConn();
			String sql = "insert into spreadinfo values(null,'官网渠道',?,?,?,'0','初始化','','李苏','2015-02-03 14:53:25','','',?,'1')";
			pstmt = conn.prepareStatement(sql);
			for(GameDTO game:games){
				pstmt.setString(1,ShortUrlCreater.createAdvNo());
				pstmt.setString(2, DOMAIN+ ShortUrlCreater.createShortUrl(game.getUrl()));
				pstmt.setString(3, game.getUrl());
				pstmt.setString(4, game.getGameName()+"官网");
				pstmt.execute();
				System.out.println("gameId:"+game.getGameId());
			}			
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
}
