package com.xunlei.niux.manager.web.task.gift;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import com.xunlei.niux.manager.web.exception.NiuxException;
import com.xunlei.niux.manager.web.util.EmailSender;
import com.xunlei.niux.manager.web.util.SmsClient;
import com.xunlei.niux.manager.web.vo.ConnUtil;

/**
 * 每日每月返利预警邮件定时任务
 * 每半小时执行一次
 * 白天发邮件提醒，晚上发邮件和短信提醒
 * @author lisu
 * 2014-09-26
 */
public class LimitGiftTask {

	private static  double percent = 0.7;
	private static  double monthPercent = 0.7;
	private static String [] smsReceivers = null;
	private static String [] mailReceivers = null;
	private static int minHour = 8;
	private static int maxHour = 20;
	private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); 
	
	public static void main(String[] args) {
		if(args != null&&args.length==2){
			minHour  = Integer.parseInt(args[0]);
			maxHour = Integer.parseInt(args[1]);
		}
		if(args != null&&args.length==4){
			minHour  = Integer.parseInt(args[0]);
			maxHour = Integer.parseInt(args[1]);
			percent = Double.parseDouble(args[2]);
			monthPercent = Double.parseDouble(args[3]);
		}
		System.out.println(sdf.format(new Date())+"   "+"LimitGiftTask  initReceivers start.......");
		initReceivers();
		System.out.println(sdf.format(new Date())+"   "+"LimitGiftTask  scanDayGift start.......");
		scanDayGift();
		System.out.println(sdf.format(new Date())+"   "+"LimitGiftTask  scanDayGift end.......");
		scanMonthGift();
		System.out.println(sdf.format(new Date())+"   "+"LimitGiftTask  scanMonthGift end.......");
	}

	private static void scanDayGift(){
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		try{
			  conn = ConnUtil.getPayConn();
			  stmt = conn.createStatement();
			  String nowDay = getNowDay();
			  String sql = "select money,limitMoney,islimit,overtime from daylimitgift where daytime='"+nowDay+"'";
			  rs = stmt.executeQuery(sql);
			  if(rs!=null&&rs.next()){
				  double money = rs.getDouble("money");
				  double limitMoney = rs.getDouble("limitMoney");
				  String overtime = rs.getString("overtime");
				  int islimit = rs.getInt("islimit");				  
				  if(islimit==1){//如果达到最大限额
					  //超额提醒邮件，汇总当然活动的返利情况
					  sendInfoGiftByDay("每日返利总金额超额提醒",nowDay,money,limitMoney,overtime);					  
				  }else{//如果没有达到最大限额
					  //判断是否达到预警条件
					  if(money>=limitMoney*percent&&money<limitMoney){
						  sendInfoGiftByDay("每日返利总金额即将超额提醒",nowDay,money,limitMoney,overtime);								  
					  }		
					  if(money>=limitMoney){
						  sendInfoGiftByDay("每日返利总金额超额提醒",nowDay,money,limitMoney,overtime);			
					  }
				  }				  
			  }
		}catch(Exception e){
			System.out.println(sdf.format(new Date())+"   "+"scanDayGift:"+e);
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	
	private static void scanMonthGift(){
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		try{
			  conn = ConnUtil.getPayConn();
			  stmt = conn.createStatement();
			  String month = getNowDay().substring(0,7);
			  String sql = "select money,limitMoney,islimit,overtime from monthlimitgift where month='"+month+"'";
			  rs = stmt.executeQuery(sql);
			  if(rs!=null&&rs.next()){
				  double money = rs.getDouble("money");
				  double limitMoney = rs.getDouble("limitMoney");
				  String overtime = rs.getString("overtime");
				  int islimit = rs.getInt("islimit");				  
				  if(islimit==1){//如果达到最大限额
					  //超额提醒邮件，汇总当然活动的返利情况
					  sendInfoGiftByMonth("每月返利总金额超额提醒",month,money,limitMoney,overtime);					  
				  }else{//如果没有达到最大限额
					  //判断是否达到预警条件
					  if(money>=limitMoney*monthPercent&&money<limitMoney){
						  sendInfoGiftByMonth("每月返利总金额即将超额提醒",month,money,limitMoney,overtime);								  
					  }		
					  if(money>=limitMoney){
						  sendInfoGiftByMonth("每月返利总金额超额提醒",month,money,limitMoney,overtime);			
					  }
				  }				  
			  }
		}catch(Exception e){
			System.out.println(sdf.format(new Date())+"   "+"scanMonthGift:"+e);
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	/**
	 * 发送每日的提醒信息，邮件或短信邮件
	 * @param title
	 * @param daytime
	 * @param money
	 * @param limitmoney
	 * @param overtime
	 */
	private static void sendInfoGiftByDay(String title,String daytime,double money,double limitmoney,String overtime){
		sendMailGiftByDay(title,daytime,money,limitmoney,overtime);		
		if(!isDay()){//如果是晚上，还需发短信
			StringBuffer content = new StringBuffer("");
			content.append("当日返利总金额：").append(money).append(", 最大限额：")
			 .append(limitmoney).append(", 超额时间：").append(overtime);
			String receivers [] = getSmsReceivers();
			 for(String phone:receivers){
				 try {
					 System.out.println(sdf.format(new Date())+"   "+"phone:"+phone);
					SmsClient.sendMonitorIdentifyingCode(phone, content.toString());
				} catch (NiuxException e) {
					System.out.println(sdf.format(new Date())+"   "+"phone:"+phone+",Exception:"+e);
				}catch (Exception e) {
					System.out.println(sdf.format(new Date())+"   "+"phone:"+phone+",Exception:"+e);
				}
			 }			
		}
	}
	
	/**
	 * 发送每月的提醒信息，邮件或短信邮件
	 * @param title
	 * @param daytime
	 * @param money
	 * @param limitmoney
	 * @param overtime
	 */
	private static void sendInfoGiftByMonth(String title,String daytime,double money,double limitmoney,String overtime){
		sendMailGiftByMonth(title,daytime,money,limitmoney,overtime);		
		if(!isDay()){//如果是晚上，还需发短信
			StringBuffer content = new StringBuffer();
			content.append("当月返利总金额：").append(money).append(", 最大限额：")
			 .append(limitmoney).append(", 超额时间：").append(overtime);
			String receivers [] = getSmsReceivers();
			 for(String phone:receivers){
				 try {
					 System.out.println(sdf.format(new Date())+"   "+"month phone:"+phone);
					SmsClient.sendMonitorIdentifyingCode(phone, content.toString());
				} catch (NiuxException e) {
					System.out.println(sdf.format(new Date())+"   "+"month phone:"+phone+",Exception:"+e);
				}catch (Exception e) {
					System.out.println(sdf.format(new Date())+"   "+"month phone:"+phone+",Exception:"+e);
				}
			 }			
		}
	}
	
	/**
	 * 是否白天
	 * @return
	 */
	private static boolean isDay(){
		Calendar cal = Calendar.getInstance();
		int hour=cal.get(Calendar.HOUR_OF_DAY);//得到小时
		System.out.println(sdf.format(new Date())+"   "+"hour:"+hour);
		return hour>=minHour && hour<=maxHour;
	}
	
	
	private static String getNowDay(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		return sdf.format(new Date());
	}
	
	
	
	private static void  sendMailGiftByDay(String title,String daytime,double money,double limitmoney,String overtime){
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		try{
			  conn = ConnUtil.getPayConn();
			  stmt = conn.createStatement();
			  String sql = "SELECT Niuxactno,SUM(TotalMoney)  STotalMoney  FROM paydetailok  WHERE GiftFlag='1' AND OrderIdStatus='S' AND SuccessTime>='"+daytime+" 00:00:00' AND SuccessTime <='"+daytime+" 23:59:59' and ToInnerUserid not in ('292604999','123540516','8326841') GROUP BY Niuxactno  ORDER BY STotalMoney  DESC;";
			  rs = stmt.executeQuery(sql);
			   StringBuffer sb = new StringBuffer();
			   sb.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html\"; charset=\"gb2312\"/></head>")
			     .append("<style type=\"text/css\">")
			     .append("body {")
			     .append("font: 75%/1.6 \"Myriad Pro\", Frutiger, \"Lucida Grande\", \"Lucida Sans\", \"Lucida Sans Unicode\", Verdana, sans-serif;}")
			     .append(" a {color: #c75f3e;}")
			     .append("#mytable {border-collapse: collapse;width: 80%;border: 1px solid #666;}")
                 .append(".mythead {background: #6d86d6;border-top: 1px solid #a5a5a5;border-bottom: 1px solid #a5a5a5;}")
                 .append("#title {font-size: 1.2em;font-weight: bold;margin: 1em 0;padding: 0;text-align:center;}")
                 .append("th {font-weight: normal;text-align: left;}")
	             .append("th,.mytd {padding: 0.1em 1em;border:1px solid #ccc;}")
	             .append("tr.mytr {background-color:#edf5ff;}")
                 .append("tr.mytr:hover {background-color: transparent;color: inherit;}")
	             .append("col {border-right: 1px solid #ccc;}")
	             .append(".red{color:red;font-weight:lighter;border:0px;}")
	             .append("</style><body id=\"thisbody\">")
	             .append("<div >")
	             .append("当日返利总金额：").append(money).append(",最大限额：").append(limitmoney).append(",超额时间：").append(overtime)
	             .append("<table id=\"mytable\" cellspacing=\"0\" align=\"center\">")
	             .append("<caption></caption>")
		         .append("<thead class=\"mythead\">")			      
				.append("<tr>")
				.append("<th scope=\"col\" class=\"myth\">序号</th>")
				.append("<th scope=\"col\" class=\"myth\">活动编号</th>")
				.append("<th scope=\"col\" class=\"myth\">当日返利总金额</th>")
				.append("</tr>")
				.append("</thead>");
			     int line = 0;
			     while(rs.next()){
					   String niuxactno = rs.getString("Niuxactno");
					   double sTotalMoney = rs.getDouble("STotalMoney");
	            	   line++;
	              	   sb.append("<tr class=\"mytr\">")
	              	  .append("<td class=\"mytd\">").append(line)
	              	  .append("<td class=\"mytd\">").append(niuxactno).append("</td>")
					  .append("<td class=\"mytd\">").append(sTotalMoney).append("</td>")
				      .append("</tr>");				     
			     }	             
	             sb.append("</table>")
	             .append(" <br><br><br>")   
		         .append(" &nbsp;&nbsp;&nbsp;迅雷牛x平台后台管理系统<br>")   
		         .append(" &nbsp;&nbsp;&nbsp;")
			     .append(" <div>")
			     .append(" <body><html>");	 
	             EmailSender.sendMail(title, sb.toString(), getReceivers());
		}catch(Exception e){
			System.out.println(sdf.format(new Date())+"   "+"sendMailGiftByDay,Exception:"+e);
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}		
	}
	
	private static void  sendMailGiftByMonth(String title,String month,double money,double limitmoney,String overtime){
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		try{
			  conn = ConnUtil.getPayConn();
			  stmt = conn.createStatement();
			  String sql = "SELECT Niuxactno,SUM(TotalMoney)  STotalMoney  FROM paydetailok  WHERE GiftFlag='1' AND OrderIdStatus='S' AND SuccessTime>='"+month+"-01 00:00:00' AND SuccessTime <='"+month+"-31 23:59:59'  and ToInnerUserid not in ('292604999','123540516','8326841') GROUP BY Niuxactno  ORDER BY STotalMoney  DESC;";
			  rs = stmt.executeQuery(sql);
			   StringBuffer sb = new StringBuffer();
			   sb.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html\"; charset=\"gb2312\"/></head>")
			     .append("<style type=\"text/css\">")
			     .append("body {")
			     .append("font: 75%/1.6 \"Myriad Pro\", Frutiger, \"Lucida Grande\", \"Lucida Sans\", \"Lucida Sans Unicode\", Verdana, sans-serif;}")
			     .append(" a {color: #c75f3e;}")
			     .append("#mytable {border-collapse: collapse;width: 80%;border: 1px solid #666;}")
                 .append(".mythead {background: #6d86d6;border-top: 1px solid #a5a5a5;border-bottom: 1px solid #a5a5a5;}")
                 .append("#title {font-size: 1.2em;font-weight: bold;margin: 1em 0;padding: 0;text-align:center;}")
                 .append("th {font-weight: normal;text-align: left;}")
	             .append("th,.mytd {padding: 0.1em 1em;border:1px solid #ccc;}")
	             .append("tr.mytr {background-color:#edf5ff;}")
                 .append("tr.mytr:hover {background-color: transparent;color: inherit;}")
	             .append("col {border-right: 1px solid #ccc;}")
	             .append(".red{color:red;font-weight:lighter;border:0px;}")
	             .append("</style><body id=\"thisbody\">")
	             .append("<div >")
	             .append("当月返利总金额：").append(money).append(",最大限额：").append(limitmoney).append(",超额时间：").append(overtime)
	             .append("<table id=\"mytable\" cellspacing=\"0\" align=\"center\">")
	             .append("<caption></caption>")
		         .append("<thead class=\"mythead\">")			      
				.append("<tr>")
				.append("<th scope=\"col\" class=\"myth\">序号</th>")
				.append("<th scope=\"col\" class=\"myth\">活动编号</th>")
				.append("<th scope=\"col\" class=\"myth\">当月返利总金额</th>")
				.append("</tr>")
				.append("</thead>");
			     int line = 0;
			     while(rs.next()){
					   String niuxactno = rs.getString("Niuxactno");
					   double sTotalMoney = rs.getDouble("STotalMoney");
	            	   line++;
	              	   sb.append("<tr class=\"mytr\">")
	              	  .append("<td class=\"mytd\">").append(line)
	              	  .append("<td class=\"mytd\">").append(niuxactno).append("</td>")
					  .append("<td class=\"mytd\">").append(sTotalMoney).append("</td>")
				      .append("</tr>");				     
			     }	             
	             sb.append("</table>")
	             .append(" <br><br><br>")   
		         .append(" &nbsp;&nbsp;&nbsp;迅雷牛x平台后台管理系统<br>")   
		         .append(" &nbsp;&nbsp;&nbsp;")
			     .append(" <div>")
			     .append(" <body><html>");	 
	             EmailSender.sendMail(title, sb.toString(), getReceivers());
		}catch(Exception e){
			System.out.println(sdf.format(new Date())+"   "+"sendMailGiftByMonth,Exception:"+e);
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}		
	}
	
	
	 private static String[] getReceivers()
	  {
	    Connection conn = null;
	    Statement stmt = null;
	    ResultSet rs = null;
	    String[] receivers = null;
	    try {
	      conn = ConnUtil.getConn();
	      stmt = conn.createStatement();
	      String sql = "select * from interfaceman where type=7";
	      stmt = conn.createStatement();
	      rs = stmt.executeQuery(sql);
	      List<String> emailist = new ArrayList<String>();
	      while (rs.next()) {
	        String email = rs.getString("interfaceEmail");
	        emailist.add(email);
	      }
	      receivers = new String[emailist.size()];
	      for (int ii = 0; ii < emailist.size(); ii++)
	        receivers[ii] = ((String)emailist.get(ii));
	    } catch (Exception ee) {
	      ee.printStackTrace();
		      try
		      {
		        if (rs != null) {
		          rs.close();
		          rs = null;
		        }
		        if (stmt != null) {
		          stmt.close();
		          stmt = null;
		        }
		        if (conn != null) {
		          conn.close();
		          conn = null;
		        }
		      } catch (Exception e) {
		        e.printStackTrace();
		      }
	    }
	    finally
	    {
	      try
	      {
	        if (rs != null) {
	          rs.close();
	          rs = null;
	        }
	        if (stmt != null) {
	          stmt.close();
	          stmt = null;
	        }
	        if (conn != null) {
	          conn.close();
	          conn = null;
	        }
	      } catch (Exception e) {
	        e.printStackTrace();
	      }
	    }
	    return receivers;
	  }
	
	 
	 private static String[] getSmsReceivers()
	  {
	    Connection conn = null;
	    Statement stmt = null;
	    ResultSet rs = null;
	    String[] receivers = null;
	    try {
	      conn = ConnUtil.getConn();
	      stmt = conn.createStatement();
	      String sql = "select * from interfaceman where type=7";
	      stmt = conn.createStatement();
	      rs = stmt.executeQuery(sql);
	      List<String> phonelist = new ArrayList<String>();
	      while (rs.next()) {
	        String phone = rs.getString("interfacePhone");
	        phonelist.add(phone);
	      }
	      receivers = new String[phonelist.size()];
	      for (int ii = 0; ii < phonelist.size(); ii++)
	        receivers[ii] = ((String)phonelist.get(ii));
	    } catch (Exception ee) {
	      ee.printStackTrace();
		      try
		      {
		        if (rs != null) {
		          rs.close();
		          rs = null;
		        }
		        if (stmt != null) {
		          stmt.close();
		          stmt = null;
		        }
		        if (conn != null) {
		          conn.close();
		          conn = null;
		        }
		      } catch (Exception e) {
		        e.printStackTrace();
		      }
	    }
	    finally
	    {
	      try
	      {
	        if (rs != null) {
	          rs.close();
	          rs = null;
	        }
	        if (stmt != null) {
	          stmt.close();
	          stmt = null;
	        }
	        if (conn != null) {
	          conn.close();
	          conn = null;
	        }
	      } catch (Exception e) {
	        e.printStackTrace();
	      }
	    }
	    return receivers;
	  }
	
	private static void initReceivers(){
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		try{
			   conn = ConnUtil.getConn();
			   stmt = conn.createStatement();
			    //找出负责人邮箱
				String sql = "select * from interfaceman where type=7";
				stmt = conn.createStatement();
				rs = stmt.executeQuery(sql);
				if(rs == null)return;
				rs.last();
				int len = rs.getRow();
				System.out.println(sdf.format(new Date())+"   "+"len:"+len);
				if(len==0)return;
				rs.first();
				smsReceivers = new String[len];
				mailReceivers = new String[len];
				int i=0;
				while(rs.next()){
					String email = rs.getString("interfaceEmail");
					String phone = rs.getString("interfacePhone");
					mailReceivers[i]=email;
					smsReceivers[i]=phone;
					i++;
				}
		}catch(Exception e){
			System.out.println(sdf.format(new Date())+"   "+"initReceivers:"+e);
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
}
