package com.xunlei.niux.manager.web.task.game;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import com.xunlei.niux.manager.web.util.AccountUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.vo.ConnUtil;
import com.xunlei.niux.manager.web.vo.TaskLogUtil;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_base;
import com.xunlei.util.StringTools;

/**
 * 牛x官网游戏在线人数查询定时任务
 * @author lisu
 * 2014-11-05
 */
public class GamePeopleTask {
		
	 private static final String GAMEPEOPLENUMURL = "http://dq2.niu.xunlei.com/getLoginRealTime?";
	 private static final Logger logger = Logger.getLogger(GamePeopleTask.class.getName());
	 private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHH");
	 
	 public static void main(String args[]){
		 logger.info("GamePeopleTask start time:"+ TaskLogUtil.getNowTime());
		 makeGamePeopleCount();
		 logger.info("GamePeopleTask end time:"+ TaskLogUtil.getNowTime());
	 }
	 

	private static String getFormatDay(){		
		return sdf.format(new Date());
	}
	
	
	
	
	private static void makeGamePeopleCount(){
		   Connection conn = null;
		   Connection ctconn = null;
		   Statement stmt = null;
		   PreparedStatement ctstmt = null;
		   ResultSet rs = null;
		   try{
			   conn = ConnUtil.getConn();
			   ctconn = ConnUtil.getConn();
			   stmt = ConnUtil.getStatement(conn);		
			   String sql = "select * from gameloginrecords order by seqId desc limit 30";
			   rs = stmt.executeQuery(sql);
			   String insertsql = "insert into gamepeoplenum(gameId,peopleNum,userName,recordTime) values(?,?,?,?)";
			   while(rs.next()){
				   String userId = rs.getString("userId");
				   String gameId = rs.getString("gameId");
				   String userName = getUserName(userId);
				   ctstmt = ctconn.prepareStatement(insertsql);
				   long peopleNum = getGamePeopleNum(gameId);
				   ctstmt.setString(1, gameId);
				   ctstmt.setLong(2, peopleNum);
				   ctstmt.setString(3, userName);
				   ctstmt.setString(4,TaskLogUtil.getNowTime());
                   ctstmt.execute();
			   }
	   }catch(Exception e){
		   e.printStackTrace();
		   logger.info("makeGamePeopleCount error:"+e.getMessage());
	   }finally{
		   try{
			   if(ctstmt != null){//关闭连接
				  ctstmt.close();
				  ctstmt = null;
			   }
			   if(rs != null){
				   rs.close();
				   rs = null;
			   }
			   if(stmt != null){
				   stmt.close();
				   stmt = null;
			   }
			   if(ctconn != null){
				   ctconn.close();
				   ctconn = null;
			   }
			   if(conn != null){
				   conn.close();
				   conn = null;
			   }
		   }catch(Exception e){
			   e.printStackTrace();
		   }
	   }						
	}
	
	private static String getUserName(String userid){
		String userName = "真命天子";
		try{
			Resp_getuserinfo_base userinfo = AccountUtil.getUserBaseInfo(userid);
			if(StringTools.isEmpty(userinfo.getNickname())){
				String uname = userinfo.getUsrname();
				if(StringTools.isEmpty(uname)){
					String account = userinfo.getUserAccount();
					if(StringTools.isEmpty(account)){					
						return userName;
					}else{
						return account;
					}
				}else{
					return uname;
				}    				
			}else{    				
				return userinfo.getNickname();
			}    
		}catch(Exception e){
			logger.info("account error:"+e.getMessage());
		}    
		return userName;
	}
	
	private static long getGamePeopleNum(String gameId){
		String formatDay = getFormatDay();
		String date = formatDay.substring(0,formatDay.length()-2);
		String hour = formatDay.substring(formatDay.length()-2);
		StringBuffer sb = new StringBuffer(GAMEPEOPLENUMURL);
		sb.append("date=").append(date).append("&hour=").append(hour).append("&gameId=").append(gameId);
		logger.info("gamePeopleNum:"+sb);		
		long peopleNum = 2000L;		
		try{		
			String jsonStr = HttpClientUtil.getInfoForHttpGetMothed(sb.toString());
			JSONObject result = new JSONObject(jsonStr);
			JSONObject data = result.getJSONObject("data");
			peopleNum = data.getLong("login");
		}catch(Exception e){
			logger.info("gamePeopleNum:"+sb+",exception:"+e.getMessage());
		}
		return peopleNum;
	}
	
}
