package com.xunlei.niux.manager.web.task.dts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.manager.web.exception.NiuxException;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.MailUtil;
import com.xunlei.niux.manager.web.util.SignMd5;
import com.xunlei.niux.manager.web.util.SmsClient;
import com.xunlei.niux.manager.web.vo.ConnUtil;
import com.xunlei.util.StringTools;

public class OnlineDataProcess {
	private static final Logger logger = Logger.getLogger(OnlineDataProcess.class.getName());	
	private static final int MAXSERVERCOUNT = 5;//一次查询的最多区服个数
	private static final String PATH = "/usr/local/templatedata/formal/niuofficial/gamedata/";
	private static  int minHour = 8;
	private static  int maxHour = 20;
	
	public static void setHour(int minHour,int maxHour){
		OnlineDataProcess.minHour = minHour;
		OnlineDataProcess.maxHour = maxHour;
	}
	
	public  static void online(String gameId,List<Map<String,Object>> josnResult){
		ResourceData data = ResourceCache.getInstance().getResourceData(gameId);
		List<String> ids = getLastestServer(gameId,MAXSERVERCOUNT);
		if(ids.size()==0)return;
		long maxCount = data.getOnlinePeopleNum();
		String serverId = checkJson(gameId);
		
		int newServerId = checkOnLineCount(gameId,ids,maxCount, serverId,data,josnResult);

		if(serverId == null){
			System.out.println("gameId:"+gameId+" ,serverId null");
			new Thread(new BuilderThread(gameId)).start();
		}else{
			System.out.println("gameId:"+gameId+" ,serverId:"+serverId+",newServerId:"+newServerId);
			if(!serverId.trim().equals(newServerId+"")){
				new Thread(new BuilderThread(gameId)).start();
			}
		}
	}

	
	/**
	 * 查询最新的limit个区服
	 * @param limit
	 * @return
	 */
	private static List<String> getLastestServer(String gameId,int limit){
		   Connection conn = null;
		   Statement stmt = null;
		   ResultSet rs = null;
		   List<String> serverList = new ArrayList<String>(5);
		   try{
			   conn = ConnUtil.getConn();
			   stmt = ConnUtil.getStatement(conn);		
			   String sql = "select * from gameservers where openstatus=1 and gameId='"+gameId+"' order by fenQuNum desc limit "+limit;
			   System.out.println(sql);
			   rs = stmt.executeQuery(sql);			
			   while(rs.next()){
				   String serverId = rs.getString("serverId");
				   System.out.println("serverId:"+serverId);
				   serverList.add(serverId);
			   }
		   }catch(Exception e){
			   logger.error("getLastestServer error:",e);
		   }finally{
			   try{
				   if(rs != null){
					   rs.close();
					   rs = null;
				   }
				   if(stmt != null){
					   stmt.close();
					   stmt = null;
				   }
				   if(conn != null){
					   conn.close();
					   conn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }
		  return serverList;
	}
	
	private static long getLastestServerId(String gameId,int serverId){
		   Connection conn = null;
		   Statement stmt = null;
		   ResultSet rs = null;
		   long sid = 0L;
		   try{
			   conn = ConnUtil.getConn();
			   stmt = ConnUtil.getStatement(conn);		
			   String sql = "select * from gameservers where openstatus=1 and gameId='"+gameId+"'  and serverId='"+serverId+"'";
			   rs = stmt.executeQuery(sql);			
			   if(rs.next()){
				   sid = rs.getLong("seqid");				  
			   }
		   }catch(Exception e){
			   logger.error("getLastestServerId error:",e);
		   }finally{
			   try{
				   if(rs != null){
					   rs.close();
					   rs = null;
				   }
				   if(stmt != null){
					   stmt.close();
					   stmt = null;
				   }
				   if(conn != null){
					   conn.close();
					   conn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }
		  return sid;
	}
	
	/**
	 * 调用游戏方接口，查询指定区服的在线人数
	 * @return
	 */
	private static int checkOnLineCount(String gameId,List<String> ids,long maxCount,String oserverId,ResourceData data,List<Map<String,Object>> josnResult){
		String key = data.getOnlinePeopleNumKey();
		String onlineUrl = data.getOnlinePeopleNumUrl();
		String serverId = getSid(ids);
		long timeStamp = System.currentTimeMillis()/1000;
		String sign = SignMd5.tomd5(serverId+timeStamp+key);
		StringBuilder params = new StringBuilder("sid=").append(serverId)
				.append("&timestamp=").append(timeStamp)
				.append("&sign=").append(sign);
		String responseText = HttpClientUtil.getInfoForHttpGetMothed(onlineUrl+params);
		System.out.println("responseText:"+responseText);
		int nextServerId = dataHandler(responseText,maxCount,oserverId,data);
		if(nextServerId != 0){			
			Map<String,Object> result = new HashMap<String,Object>();
			result.put("gameid",gameId);
			result.put("fenquno",nextServerId);
			long sid = getLastestServerId(gameId,nextServerId);
			result.put("sid",sid);
			josnResult.add(result);		
			System.out.println("josnResult:"+josnResult);		
		}		
		return nextServerId;
	}

	 private static String checkJson(String gameId){
	    	String serverId = null;
	    	try{
	    		File file = new File(PATH+"gameimportserver.json");
	    		if(!file.exists()){
	    			file.createNewFile();
	    		}
		    	String json = readByChar(file);
		    	if(StringTools.isEmpty(json))return null;
		    	try {
					JSONArray jsonObject = new JSONArray(json);
					for(int i=0;i<jsonObject.length();i++){
						JSONObject obj = (JSONObject)jsonObject.get(i);
						String mygameId = "";			
						try{
							mygameId = obj.getString("gameid");			
						}catch(JSONException je){
							return null;
						}						
						if(StringTools.isEmpty(mygameId))continue;
						if(gameId.trim().equals(mygameId.trim())){
							serverId = obj.getString("fenquno");
						}
					}					
				} catch (JSONException e) {		
					e.printStackTrace();
				}
	    	}catch(Exception e){
	    		e.printStackTrace();
	    	}
	    
	    	return serverId;
	    }

	    public static  String readByChar(File file){
			BufferedReader reader=null;
			try{
				StringBuilder sb=new StringBuilder();
				reader=new BufferedReader(new InputStreamReader(new FileInputStream(file),"UTF-8"));
				char[] buf=new char[1024];
				int len=-1;
				while((len=reader.read(buf))!=-1){
					sb.append(buf,0,len);
				}
				return sb.toString();
			}catch(Exception e){
				e.printStackTrace();
			}finally{
				try{
					if(reader != null){
						reader.close();
						reader = null;
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
			return "";
		}
	
	private static int dataHandler(String responseText,long maxCount,String oserverId,ResourceData data){
		double percent = data.getPercent();
		double changePercent = data.getChangePercent();
		int nextServerId = 0;
		try {
			JSONArray array = new JSONArray(responseText);			
			StringBuilder preBuilder = new StringBuilder();
			StringBuilder builder = new StringBuilder();
			for(int i=0;i<=array.length()-1;i++){
				JSONObject jobject = (JSONObject)array.get(i);
				int serverId = jobject.getInt("server");
				//long onLine = jobject.getLong("online");
				long onLine = 0L;
				String onLineStr = jobject.getString("online");
				if(!StringTools.isEmpty(onLineStr)){
					onLine = Long.parseLong(onLineStr);
				}
				if(onLine < changePercent*maxCount){
				}else if(onLine>=changePercent*maxCount&&onLine<maxCount){
					preBuilder.append("区服：").append(serverId).append(",在线人数：").append(onLine).append("|");
				}else{
					builder.append("区服：").append(serverId).append(",在线人数：").append(onLine).append("|");	
				}
			}		
			boolean flag = false;
			for(int i=0;i<=array.length()-1;i++){
				JSONObject jobject = (JSONObject)array.get(i);
				int serverId = jobject.getInt("server");
				long onLine = jobject.getLong("online");
				if(onLine<percent*maxCount){
					if(i==0){//最新服
						if(oserverId!=null){
							if(serverId != Integer.parseInt(oserverId)){//如果之前已经切走
								if(onLine<=changePercent*maxCount){
									nextServerId = serverId;
								}else{
									nextServerId = Integer.parseInt(oserverId);		
								}
							}else{
								nextServerId = Integer.parseInt(oserverId);							
							}
						}else{
							nextServerId = serverId;			
						}
						
					}else{
						nextServerId = serverId;								
					}	
					flag = true;
					break;
				}
			}
			if(!flag){
				for(int i=0;i<=array.length()-1;i++){
					JSONObject jobject = (JSONObject)array.get(i);
					int serverId = jobject.getInt("server");
					long onLine = jobject.getLong("online");
					if((onLine>=changePercent*maxCount&&onLine<maxCount)){
						nextServerId = serverId;
						break;
					}
				}
			}			
			process(preBuilder,builder,data);
		} catch (JSONException e) {
			   e.printStackTrace();
			  logger.error("dataHandler error:",e);
		}
		return nextServerId;
	}
	
	
	private static void process(StringBuilder preBuilder ,StringBuilder builder,ResourceData data){
		String gameName = data.getGameName();
		if(preBuilder.length()==0&&builder.length()==0)return;
		List<String> numberList = getContantNumber();
		if(preBuilder.length()>0){//发邮件
			System.out.println("sendMail start........");
			sendMail(numberList,"《"+gameName+"》快要爆服提醒",preBuilder.toString());
			System.out.println("sendMail end........");
		}
		if(builder.length()>0){//发邮件 + 短信
			System.out.println("sendMail and sms  start........");
			sendMail(numberList,"《"+gameName+"》已爆服提醒",builder.toString());
			if(!isWorkTime()){//如果是非工作时间发短信
				sendSms(numberList,"《"+gameName+"》已爆服区服情况："+builder);
				System.out.println("sendMail and sms  end........");
			}
		}
	}
	
	/**
	 * 判断是否工作时间
	 * @return
	 */
	private static boolean isWorkTime(){
		Calendar cal = Calendar.getInstance();
		int hour=cal.get(Calendar.HOUR_OF_DAY);//得到小时
		System.out.println("hour:"+hour);
		return hour>=minHour && hour<=maxHour;
	}
	
	private static String getSid(List<String> ids){
		String sid = "";
		if(ids == null||ids.size()==0)return null;
		if(ids.size()>1){
			for(int i=0;i<ids.size()-1;i++){
				sid += ids.get(i)+"_";
			}
			sid +=ids.get(ids.size()-1);
		}else{
			sid +=ids.get(0);
		}		
		return sid;
	}
	
	/**
	 * 获得联系方式
	 * @return
	 */
	private static List<String> getContantNumber(){
		   Connection conn = null;
		   Statement stmt = null;
		   ResultSet rs = null;
		   List<String> numberList = new ArrayList<String>(20);
		   try{
			   conn = ConnUtil.getConn();
			   stmt = ConnUtil.getStatement(conn);		
			   String sql = "select * from interfaceman where type=9";
			   rs = stmt.executeQuery(sql);			
			   while(rs.next()){
				   String interfacePhone = rs.getString("interfacePhone");
				   String interfaceEmail = rs.getString("interfaceEmail");
				   numberList.add(interfacePhone+"_"+interfaceEmail);
			   }
		   }catch(Exception e){
			   logger.error("getContantNumber error:",e);
		   }finally{
			   try{
				   if(rs != null){
					   rs.close();
					   rs = null;
				   }
				   if(stmt != null){
					   stmt.close();
					   stmt = null;
				   }
				   if(conn != null){
					   conn.close();
					   conn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }
		  return numberList;
	}
	
	/**
	 * 发送邮件
	 * @param mails
	 */
	private static void sendMail(List<String> numberList,String title,String content){
		String receivers [] = new String[numberList.size()];
		for(int i=0;i<numberList.size();i++){
			receivers[i] = numberList.get(i).split("_")[1];
		}
		try {
			MailUtil.sendMail(title, content, receivers);
		} catch (Exception e) {			
			e.printStackTrace();
			 logger.error("sendMail error:",e);
		}
	}
	
	/**
	 * 生成json文件
	 */
	public static void makeJsonFile(String path,String fileName,List<Map<String,Object>> data){
	 	logger.info("开始生成文件："+fileName);
		String jsonStr=JsonObjectUtil.getDataJsonObject(data);
		File file = FileUtil.createFile(path,fileName);
		FileUtil.writeByChar(file, jsonStr);			
	}
	

	
	/**
	 * 发送短信
	 * @param sms
	 */
	private static void sendSms(List<String> numberList,String content){
		for(int i=0;i<numberList.size();i++){
			try {
				SmsClient.sendSms(numberList.get(i).split("_")[0], content);
			} catch (NiuxException e) {
				e.printStackTrace();
				 logger.error("sendSms error:",e);
			}
		}		
	}
}
