package com.xunlei.niux.manager.web.task.dts;


import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.log4j.Logger;

import com.xunlei.niux.manager.web.vo.ConnUtil;

/**
 * 每个5分钟调用一次游戏方接口获取在线人数
 * @author lisu
 * 
 */
public class DtsTask {
	private static final Logger logger = Logger.getLogger(DtsTask.class.getName());	
	private static final String CMDNAME = "rsync_niuofficial_formal.sh";
	private static final String PATH = "/usr/local/templatedata/formal/niuofficial/gamedata/";
	private static  int minHour = 8;
	private static  int maxHour = 20;
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		logger.info("DtsTask start..........");
		if(args!=null&&args.length==2){
			minHour = Integer.parseInt(args[0]);
			maxHour = Integer.parseInt(args[1]);
			OnlineDataProcess.setHour(minHour,maxHour);
		}
		execute();
		logger.info("DtsTask end..........");
		synch(CMDNAME);
		logger.info("synch end..........");
	}
	
	
	private static List<String> getGameChannel(String gameId){
		  Connection conn = null;
		   Statement stmt = null;
		   ResultSet rs = null;
		   List<String> serverList = new ArrayList<String>();
		   try{
			   conn = ConnUtil.getConn();
			   stmt = ConnUtil.getStatement(conn);		
			   String sql = "select * from linkinfo where linklocid='291' and gameid='"+gameId+"'";
			   System.out.println(sql);
			   rs = stmt.executeQuery(sql);			
			   while(rs.next()){
				   String channelId = rs.getString("ext1");
				   serverList.add(channelId);
			   }
		   }catch(Exception e){
			   logger.error("getGameChannel error:",e);
		   }finally{
			   try{
				   if(rs != null){
					   rs.close();
					   rs = null;
				   }
				   if(stmt != null){
					   stmt.close();
					   stmt = null;
				   }
				   if(conn != null){
					   conn.close();
					   conn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }
		  return serverList;
	}
	
	private static void execute(){
		List<Map<String,Object>> josnResult = new ArrayList<Map<String,Object>>();
		for(Entry<String,ResourceData> entry:ResourceCache.getInstance().getResourceSet()){
			String gameId = entry.getKey();
					System.out.println("gameid:"+gameId);
			OnlineDataProcess.online(gameId,josnResult);			
		}		
		System.out.println("josnResult=========>"+josnResult);
		OnlineDataProcess.makeJsonFile(PATH,"gameimportserver.json",josnResult);
		for(Map<String,Object> map :josnResult){
			String gameId = (String)map.get("gameid");
			List<String> channelList = getGameChannel(gameId);
			for(String channelId:channelList){
				makeChannelJson(map,channelId);
			}			
		}
	}
	
	private static void makeChannelJson(Map<String,Object> map,String channelId){		
		List<Map<String,Object>> list = new ArrayList<Map<String,Object>>(1);
		list.add(map);
		OnlineDataProcess.makeJsonFile(PATH,channelId+".json",list);
	}
	
	/**
	 * 同步文件
	 */
	private static void synch(String cmdName){
		 try {
			 logger.info("开始同步文件,地址:/usr/local/bin/"+cmdName);
			 Runtime.getRuntime().exec("/usr/local/bin/"+cmdName);		
			 logger.info("同步文件完毕,地址:/usr/local/bin/"+cmdName);
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
	}

	
}
