package com.xunlei.niux.manager.web.task.business;

import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.vo.ConnUtil;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.*;

/**
 * Created by lizeyu on 2015/11/6.
 * 每天凌晨把前一天的手游的营收数据更新到手游官网相关表的ext8字段中，手游官网根据该字段进行排序
 */
public class MobileWebBuilderTask{

    public static void main(String[] args){
        Date yesterDay = DateUtil.yesterday();
        String yesterDayStr = DateUtil.format(yesterDay, "yyyy-MM-dd");

        System.out.println("MobileWebBuilderTask start, date:" + yesterDayStr);
        //更新好玩手机游戏推荐
        updateGameIncome("696", yesterDayStr);
        //更新周排行
        updateGameIncome("699", yesterDayStr);
        //更新月排行
        updateGameIncome("697", yesterDayStr);
        //更新手游中心
        updateGameIncome("1276", yesterDayStr);

        System.out.println("MobileWebBuilderTask end, date:" + yesterDayStr);
    }

    /**
     * 1、从linkinfo表中取出linkLocId对应的所有游戏列表
     * 2、根据gameId从chargedayend表中取出当天该游戏的营收
     * 3、将游戏的营收字段更新到linkinfo表中对应的ext8字段
     * @param linkLocId
     * @param curDate
     */
    private static void updateGameIncome(String linkLocId, String curDate){
        List<String> gameList = getGameList(linkLocId);
        List<Map<String, String>> gameIncomeMap = getGameIncomeMap(gameList, curDate);

        for(Map<String, String> map : gameIncomeMap){
            System.out.println(map.get("gameId") + ":" + map.get("incomeAmt"));
        }

        updateLinkInfo(linkLocId, gameIncomeMap);
    }

    private static void updateLinkInfo(String linkLocId, List<Map<String, String>> gameIncomeMap){
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;

        try{
            conn = ConnUtil.getConn();
            String sql = "update linkinfo set ext8=? where linklocid=? and gameidbytuijian=?";

            for(Map<String, String> map: gameIncomeMap){
                String gameId = map.get("gameId");
                String incomeAmtStr = map.get("incomeAmt");
                Double incomeAmt =  Double.parseDouble(incomeAmtStr);//将incomeAmt转为整数字符串，便于比较

                pstmt = conn.prepareStatement(sql);
                pstmt.setDouble(1, incomeAmt);
                pstmt.setString(2, linkLocId);
                pstmt.setString(3, gameId);
                pstmt.execute();
            }
        }catch(Exception e){
            e.printStackTrace();
        }finally{
            try{
                if(pstmt != null){
                    pstmt.close();
                    pstmt = null;
                }

                if(rs != null){
                    rs.close();
                    rs = null;
                }
                if(conn != null){
                    conn.close();
                    conn =null;
                }
            }catch(Exception e){
                e.printStackTrace();
            }
        }
    }

    private static  List<Map<String, String>> getGameIncomeMap(List<String> gameList, String balanceDate){
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;

        List<Map<String, String>> resultMap = new ArrayList<Map<String, String>>();
        try{
            conn = ConnUtil.getPayConn();

            for(String gameId : gameList){
                String sql = "select incomeamt from chargedayend where balancedate=? and gameId=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, balanceDate);

                String newGameIdStr = gameId;
                if(newGameIdStr.startsWith("05")){
                    newGameIdStr = newGameIdStr.substring(1);
                }
                pstmt.setString(2, newGameIdStr);
                rs = pstmt.executeQuery();

                String incomAmt = "";
                while(rs.next()){
                    incomAmt = rs.getString(1);
                }

                Map<String, String> map = new HashMap<String, String>();
                map.put("gameId", gameId);
                map.put("incomeAmt", "".equals(incomAmt) ? "0" : incomAmt);

                resultMap.add(map);
            }

        }catch(Exception e){
            e.printStackTrace();
        }finally{
            try{
                if(pstmt != null){
                    pstmt.close();
                    pstmt = null;
                }

                if(rs != null){
                    rs.close();
                    rs = null;
                }
                if(conn != null){
                    conn.close();
                    conn =null;
                }
            }catch(Exception e){
                e.printStackTrace();
            }
        }

        return resultMap;
    }

    private static List<String> getGameList(String linkLocId){
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;

        List<String> resultList = new ArrayList<String>();
        try{
            conn = ConnUtil.getConn();
            String sql = "select gameidbytuijian from linkinfo where linklocid=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, linkLocId);
            rs = pstmt.executeQuery();

            while(rs.next()){
                resultList.add(rs.getString(1));
            }
        }catch(Exception e){
            e.printStackTrace();
        }finally{
            try{
                if(rs != null){
                    rs.close();
                    rs = null;
                }
                if(pstmt != null){
                    pstmt.close();
                    pstmt = null;
                }
                if(conn != null){
                    conn.close();
                    conn = null;
                }
            }catch(Exception e){
                e.printStackTrace();
            }
        }

        return resultList;
    }
}

