package com.xunlei.niux.manager.web.proxy;

import java.io.File;

import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.manager.web.util.FileUtil;

public class SynchGameInfoToBoxProxy {
	
	private static final String BOX_DATA_LOCATION =  IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("boxDataUrl");	
	private static SynchGameInfoToBoxProxy instance = new SynchGameInfoToBoxProxy();
	
	private SynchGameInfoToBoxProxy(){
		
	}
	
	public static SynchGameInfoToBoxProxy getInstance(){
		if(instance == null){
			instance = new SynchGameInfoToBoxProxy();
		}
		return instance;
	}
	
	public void makeAllGameListJS(final Object allGameList,final Object hotGameList){
		//游戏信息
		String jsonStr=JsonObjectUtil.getDataJsonObject(allGameList);
		jsonStr = "var ALL_GAME_LIST="+jsonStr+";";
		
		File file = FileUtil.createFile(BOX_DATA_LOCATION,"gameInfo.js");
		FileUtil.writeByChar(file, jsonStr);

        String hotGameStr = "var HOT_GAME_LIST="+JsonObjectUtil.getDataJsonObject(hotGameList)+";";
        File hotfile = FileUtil.createFile(BOX_DATA_LOCATION,"hotGames.js");
        FileUtil.writeByChar(hotfile, hotGameStr);
	}
}
