package com.xunlei.niux.manager.web.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.GameServers;

/**
 * 生成同步给盒子 的 最新区服 和 活动、攻略 的 json文件
 * @author lisu
 *	2014-08-18
 */
public class SynchBoxNewServerAdviceProxy extends BaseProxy{
	private static final SynchBoxNewServerAdviceProxy  instance = new SynchBoxNewServerAdviceProxy();
    private static  String path = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("wholePeopleGuestPath");
	private static final String activityCmd = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("wholePeopleGuestCmd");	
	
	private SynchBoxNewServerAdviceProxy(){
		
	}
	
	public static SynchBoxNewServerAdviceProxy getInstance(){
		return instance;
	}
	
	
	public void makeServerAndAdvice(String gameId){
		Map<String,Object> data = new HashMap<String,Object>();
		makeNewServer(data,gameId);
		makeAdvice(data,gameId);	
		super.makeData(data, path+"/box", gameId+".js", "var rightbox=", activityCmd);
	}
	
	private String getBoxUrl(String url){
		if(StringTools.isEmpty(url))return "";
		if(url.indexOf("/a/")!=-1){
			return url.replace("/a/", "/gamebox/");
		}
		return url;
	}
	
	/**
	 * 获得该游戏的最新区服数据
	 * @param result
	 * @param gameId
	 */
	private void makeNewServer(Map<String,Object> result,String gameId){		
		GameServers query = new GameServers();
		query.setGameId(gameId);
		query.setOpenStatus("1");//已开区
		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("openTime", OrderType.DESC);
		List<GameServers> gslist = FacadeFactory.INSTANCE.getGameServersBo().find(query, page);
		Map<String,Object> newServerMap = new HashMap<String,Object>();
		Map<String,Object> nextServerMap = new HashMap<String,Object>();
		if(CollectionUtils.isEmpty(gslist)){
			result.put("new_server", newServerMap);
			result.put("next_server", nextServerMap);
			return ;
		}
		GameServers gs = gslist.get(0);			
		newServerMap.put("sid", gs.getSeqId());
		newServerMap.put("serverid", gs.getServerId());
		newServerMap.put("opentime", gs.getOpenTime());
		result.put("new_server", newServerMap);
		query = new GameServers();
		query.setGameId(gameId);
		//query.setServerId((Long.parseLong(gs.getServerId())+1)+"");
		query.setFromopentime(gs.getOpenTime());
		Page page1 = new Page();
		page1.addOrder("openTime", OrderType.ESC);
		gslist =FacadeFactory.INSTANCE.getGameServersBo().find(query, page1);
		if(gslist.size()==1){			
			result.put("next_server", nextServerMap);
		}else{
			GameServers mygs = gslist.get(1);	
			nextServerMap.put("sid", mygs.getSeqId());
			nextServerMap.put("serverid", mygs.getServerId());
			nextServerMap.put("opentime", mygs.getOpenTime());
			result.put("next_server",nextServerMap);
		}		
	}
	
	private void makeAdvice(Map<String,Object> result,String gameId){
		List<Map<String,String>> actlist = new ArrayList<Map<String,String>>();
		List<Map<String,String>> strategylist = new ArrayList<Map<String,String>>();
		Advice query = new Advice();
		query.setAdviceType("3");//官网
		query.setGameId(gameId);
		query.setIsSychBox(true);
		Page page = new Page();
		page.addOrder("publishDate", OrderType.DESC);
		List<Advice> adlist =FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		if(CollectionUtils.isEmpty(adlist)){
			result.put("act_config", actlist);
			result.put("strategy_config", strategylist);
		}else{
			for(Advice adv:adlist){
				String jumpUrl = adv.getJumpUrl();
				if(StringTools.isEmpty(jumpUrl))continue;
				Map<String,String> map = new HashMap<String,String>();
				map.put("title", adv.getTitle());
				map.put("url", getBoxUrl(adv.getJumpUrl()));
				map.put("imgurl", adv.getPhoto());
				if(adv.getPlatformno().equals("huodong")){				
					actlist.add(map);
				}else if(adv.getPlatformno().equals("gonglue")){
					strategylist.add(map);
				}				
			}
			result.put("act_config", actlist);
			result.put("strategy_config", strategylist);			
		}
	}
	
}
