package com.xunlei.niux.manager.web.proxy;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import com.xunlei.niux.manager.web.exception.NiuxException;
import com.xunlei.niux.manager.web.util.SmsClient;
import com.xunlei.util.StringTools;

public class SmsProxy {
	private static final int MAX_LEN = 64;
	private static final SmsProxy instance = new SmsProxy();

	private SmsProxy() {

	}

	public static SmsProxy getInstance() {
		return instance;
	}

	/**
	 * 测试手机发送短信的内容
	 * 
	 * @param testPhone
	 * @param message
	 * @throws RuntimeException
	 */
	public void testSms(String testPhone, String message) throws NiuxException {
		int len = message.length();
		System.out.println("len:" + len);
		if (len > MAX_LEN) {
			System.out.println("短信内容超过" + MAX_LEN + "个字节");
			throw new NiuxException("11", "短信内容超过" + MAX_LEN + "个字节");
		}
		testsend(testPhone, message);

	}

	/**
	 * 测试手机发送短信的内容
	 * 
	 * @param testPhone
	 * @param message
	 * @throws RuntimeException
	 */
	public void testSmsActivationCode(String testPhone, String message) throws NiuxException {
		int len = message.length();
		System.out.println("len:" + len);
		if (len > MAX_LEN) {
			System.out.println("短信内容超过" + MAX_LEN + "个字节");
			throw new NiuxException("11", "短信内容超过" + MAX_LEN + "个字节");
		}
		testsend(testPhone, message + "。激活码：nkiiolkl908kkd");

	}

	/**
	 * 读取文件中的手机号，发送正式短信
	 * 
	 * @param message
	 * @param fileName
	 * @throws RuntimeException
	 */
	public long sendSms(String message, String fileName) throws Exception {
		// String message =
		// "亲爱的玩家，迅雷牛X《傲世九重天》首服于7月14日14时开启，参与游戏即可获得价值200元的试玩礼包一份，礼包丰厚，不要错过哦！";
		int len = message.length();
		System.out.println("len:" + len);
		if (len > MAX_LEN) {
			System.out.println("短信内容超过" + MAX_LEN + "个字节");
			throw new Exception("短信内容超过" + MAX_LEN + "个字节");
		}
		long count = 0;// 发送成功数量
		try {
			List<String> set = getUserInfoList(fileName);
			String key = "";
			if (fileName.indexOf("/") != -1) {
				key = fileName.substring(fileName.lastIndexOf("/") + 1);
			}
			int i = 0;
			for (int ii = 0; ii < set.size(); ii++) {
				String mobile = set.get(ii);
				String data = JRedisProxy.getInstance().get(key);
				if (!StringTools.isEmpty(data)) {// 如果有缓存
					count = Integer.parseInt(data);// 获得缓存数据
					if (ii < count) {
						continue;
					}
				}
				boolean flag = send(mobile, message);
				if (!flag) {// 如果第一次发送失败
					System.out.println("重发");
					flag = send(mobile, message);
					if (flag) {// 如果第二次发送成功
						count++;
						JRedisProxy.getInstance().set(key, count + "",
								Integer.MAX_VALUE);
					}
				} else {
					count++;
					JRedisProxy.getInstance().set(key, count + "",
							Integer.MAX_VALUE);
				}
				System.out.println(++i);
				Thread.sleep(100);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return count;
	}

	/**
	 * 读取文件中的手机号，发送短信激活码
	 * 
	 * @param message
	 * @param fileName
	 * @throws RuntimeException
	 */
	public Map<String, String> sendSmsActivationCode(String message,
			String fileName, List<String> activationCodeList) throws Exception {
		int len = message.length();
		System.out.println("len:" + len);
		if (len > MAX_LEN) {
			System.out.println("短信内容超过" + MAX_LEN + "个字节");
			throw new Exception("短信内容超过" + MAX_LEN + "个字节");
		}
		long count = 0;// 发送成功数量
		Map<String, String> succMap = new HashMap<String, String>();
		try {
			List<String> set = getUserInfoList(fileName);
			String key = "";
			if (fileName.indexOf("/") != -1) {
				key = fileName.substring(fileName.lastIndexOf("/") + 1);
			}
			int i = 0;
			for (int ii = 0; ii < set.size(); ii++) {
				String mobile = set.get(ii);
				String activationCode = activationCodeList.get(ii);

				String data = JRedisProxy.getInstance().get(key);
				if (!StringTools.isEmpty(data)) {// 如果有缓存
					count = Integer.parseInt(data);// 获得缓存数据
					if (ii < count) {
						continue;
					}
				}
				boolean flag = send(mobile, message + "。激活码：" + activationCode);
				if (!flag) {// 如果第一次发送失败
					System.out.println("重发");
					flag = send(mobile, message + "。激活码：" + activationCode);
					if (flag) {// 如果第二次发送成功
						count++;
						JRedisProxy.getInstance().set(key, count + "",
								Integer.MAX_VALUE);
						succMap.put(mobile, activationCode);
					}
				} else {
					count++;
					JRedisProxy.getInstance().set(key, count + "",
							Integer.MAX_VALUE);
					succMap.put(mobile, activationCode);
				}
				System.out.println(++i);
				Thread.sleep(100);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return succMap;
	}

	public void testsend(String mobile, String message) throws NiuxException {
		SmsClient.sendSms(mobile, message);
	}

	public boolean send(String mobile, String message) {
		try {
			SmsClient.sendSms(mobile, message);
			return true;
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
	}

	public List<String> getUserInfoList(String fileName) throws Exception {
		List<String> list = new ArrayList<String>();
		HashSet<String> set = new HashSet<String>();
		// String fileName="E:\\lostcustomer.txt";
		BufferedReader br = new BufferedReader(new FileReader(fileName));
		String data = br.readLine();
		while (data != null) {
			if (set.contains(data) == false) {
				list.add(data);
				set.add(data);
			}
			data = br.readLine();
		}
		br.close();
		return list;
	}

	public int getUserInfoCount(String fileName) throws Exception {
		List<String> lists = getUserInfoList(fileName);
		return lists.size();
	}

}
