package com.xunlei.niux.manager.web.proxy;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.util.StringTools;

public class ServerActivityCountProxy {
	private static final Logger logger = Logger.getLogger(ServerActivityCountProxy.class.getName());	
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat timeSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static final ServerActivityCountProxy instance = new ServerActivityCountProxy();
    private static  String wholePeopleGuestPath=IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("wholePeopleGuestPath");
	private static final String activityCmd = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("wholePeopleGuestCmd");	
    
	private ServerActivityCountProxy(){

	}
	
	public static ServerActivityCountProxy getInstance(){
		  return instance;
	}
	
	 public void sync(){
		 try {
			 logger.info("开始同步活动页文件,地址:/usr/local/bin/"+activityCmd);
			 Runtime.getRuntime().exec("/usr/local/bin/"+activityCmd);			
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
	 }
	
	public void makeServerActivityCountJS(){
		Calendar cal = Calendar.getInstance();
		String nowTime = timeSdf.format(cal.getTime());
		cal.add(Calendar.DAY_OF_YEAR, -3);
		String beforeDay = sdf.format(cal.getTime());
		Map<String,Object> result = new HashMap<String,Object>();
		List<Games> gamesList = GameCache.getInstance().getAllGames();
		String queryserversql = "SELECT gameid ,COUNT(serverid) scount FROM gameservers WHERE openTime >= '"+beforeDay+"'  AND openTime < '"+nowTime+"' GROUP BY gameid ";
	    List<CountData> serverCountList = FacadeFactory.INSTANCE.getBaseSo().executeQuery(CountData.class, queryserversql, new ArrayList());			
	    String queryactivitysql = "SELECT gameid ,COUNT(actno) scount FROM activity_activity WHERE actstatus=1 and gameType=1 group by gameid";
	    List<CountData> activityCountList = com.xunlei.niux.data.activity.facade.FacadeFactory.INSTANCE.getBaseSo().executeQuery(CountData.class, queryactivitysql, new ArrayList());
		for(Games game:gamesList){
			if(game==null||StringTools.isEmpty(game.getGameId()))continue;
			if(!"1".equals(game.getStatus())||game.getClientType().intValue()==3){
				continue;
			}
			makeData(result,game.getGameId(),serverCountList,activityCountList);
		}
		
		String jsonStr=JsonObjectUtil.getDataJsonObject(result);
		jsonStr = "var GAME_SERVER_ACTIVITY_COUNT="+jsonStr;
		File file = FileUtil.createFile(wholePeopleGuestPath+"/activity","serveractcount.js");
		FileUtil.writeByChar(file, jsonStr);		
		sync();//同步文件到前端服务器
	}
	
	
	private void makeData(Map<String,Object> result,String gameId,List<CountData> serverCountList,List<CountData> activityCountList){
			   int servercount = 0;
			   int gamecount = 0;
		       for(CountData scount:serverCountList){
		    	   if(scount==null)continue;
		    	   if(scount.getGameId().equals(gameId)){
		    		   servercount = scount.getScount()==null?0:scount.getScount().intValue();
		    	   }
		       }
		       for(CountData acount:activityCountList){
		    	   if(StringTools.isEmpty(acount.getGameId()))continue;
		    	   if(acount.getGameId().equals(gameId)){
		    		   gamecount = acount.getScount()==null?0:acount.getScount().intValue();
		    	   }
		       }
				Map<String,Integer> map = new HashMap<String,Integer>();
				map.put("s", servercount);
				map.put("a", gamecount);
				if(servercount!=0||gamecount!=0)
				   result.put(gameId, map);
	}
}
