package com.xunlei.niux.manager.web.proxy;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.RebateApply;
import com.xunlei.niux.data.vipgame.vo.RebateOrder;
import com.xunlei.niux.data.vipgame.vo.RebateOrderPhoto;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.model.RebateApplyManagedBean;
import com.xunlei.niux.manager.web.util.EmailSender;

public class RebateApplyProxy {
      private static final SimpleDateFormat sdf =new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	  private static final RebateApplyProxy instance = new RebateApplyProxy();
	  private RebateApplyProxy(){
		  
	  }	  
	  public static RebateApplyProxy getInstance(){
		  return instance;
	  }

	  /**
	   * 注意此方法 titles 和 receivers 必须一一对应
	   * @param aporderid
	   * @param titles
	   * @param prefixContent
	   * @param receivers
	   * @throws Exception
	   */
	  public void sendMail(String aporderid,List<String> titles,String prefixContent,List<String> receivers) throws Exception{
		  RebateApply apply = new RebateApply();
		  apply.setAporderid(aporderid);
		  RebateApply rebateApply = FacadeFactory.INSTANCE.getBaseSo().findObject(apply);
		  
		  Page page = new Page();
		  RebateOrder order = new RebateOrder();
		  order.setAporderid(aporderid);
		  List<RebateOrder> rolist = FacadeFactory.INSTANCE.getBaseSo().findObjects(order, page);
		  
		  RebateOrderPhoto photo = new RebateOrderPhoto();
		  photo.setAporderid(aporderid);
		  List<RebateOrderPhoto> roplist = FacadeFactory.INSTANCE.getBaseSo().findObjects(photo, page);
		  
		  StringBuffer buffer = getHtmlBuffer(prefixContent,rebateApply,rolist,roplist);
		  for(int i=0;i<titles.size();i++)
		      EmailSender.sendMail(titles.get(i), buffer.toString(),receivers.get(i));		  
	  }
	  
	  public void sendMail(String aporderid,String title,String prefixContent,List<String> receivers) throws Exception{
		  RebateApply apply = new RebateApply();
		  apply.setAporderid(aporderid);
		  RebateApply rebateApply = FacadeFactory.INSTANCE.getBaseSo().findObject(apply);
		  
		  Page page = new Page();
		  RebateOrder order = new RebateOrder();
		  order.setAporderid(aporderid);
		  List<RebateOrder> rolist = FacadeFactory.INSTANCE.getBaseSo().findObjects(order, page);
		  
		  RebateOrderPhoto photo = new RebateOrderPhoto();
		  photo.setAporderid(aporderid);
		  List<RebateOrderPhoto> roplist = FacadeFactory.INSTANCE.getBaseSo().findObjects(photo, page);
		  
		  StringBuffer buffer = getHtmlBuffer(prefixContent,rebateApply,rolist,roplist);
		  if(buffer != null)
		      EmailSender.sendMail(receivers, title, buffer.toString());		  
	  }
	  
	  private StringBuffer getHtmlBuffer(String prefixContent,RebateApply apply,List<RebateOrder> rolist,List<RebateOrderPhoto> roplist){
		  if(apply == null)return null;
		  Games games = GameCache.getInstance().getGameByGameId(apply.getGameid());		  
		  StringBuffer html = new StringBuffer();
			 html.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html\"; charset=\"gb2312\"/></head>")
		       .append("<style type=\"text/css\">")
		       .append("body {")
		       .append("font: 75%/1.6 \"Myriad Pro\", Frutiger, \"Lucida Grande\", \"Lucida Sans\", \"Lucida Sans Unicode\", Verdana, sans-serif;}")
		       .append(" a {color: #c75f3e;}")
		       .append("#mytable {border-collapse: collapse;width: 80%;border: 1px solid #666;}")
	           .append(".mythead {background: #6d86d6;border-top: 1px solid #a5a5a5;border-bottom: 1px solid #a5a5a5;}")
	           .append("#title {font-size: 1.2em;font-weight: bold;margin: 1em 0;padding: 0;text-align:center;}")
	           .append("th {font-weight: normal;text-align: left;}")
	           .append("th,.mytd {padding: 0.1em 1em;border:1px solid #ccc;}")
	           .append("tr.mytr {background-color:#edf5ff;}")
	           .append("tr.mytr:hover {background-color: transparent;color: inherit;}")
	           .append("col {border-right: 1px solid #ccc;}")
	           .append(".red{color:red;font-weight:lighter;border:0px;}")
	           .append("</style><body id=\"thisbody\">")
	           .append(prefixContent).append("<br/>")
	           .append("<table><tr class='mytr'><td class='mytd'>").append("返利申请单号：").append("</td><td class='mytd'>").append(apply.getAporderid()) .append("</td><td class='mytd'>").append("返利类型：").append("</td><td class='mytd'>").append(RebateApplyManagedBean.typeMap.get(apply.getApplyType())).append("</td><td class='mytd'>").append("").append("</td><td class='mytd'>") .append("</td>").append("</tr>")
	                             .append("<tr class='mytr'><td colspan='6'  class='mytd'></td></tr>")
	                             .append("<tr class='mytr'><td  class='mytd'>").append("游戏名称：").append("</td><td class='mytd'>").append(games.getGameName()).append("</td><td class='mytd'>").append("区服：").append("</td><td class='mytd'>").append(apply.getServerid()).append("</td><td class='mytd'>道具名称</td><td class='mytd'>").append(apply.getPropName()).append("</td></tr>")
	                             .append("<tr class='mytr'><td  class='mytd'>").append("迅雷UID：").append("</td><td class='mytd'>").append(apply.getUid()).append("</td><td class='mytd'>").append("充值帐号：").append("</td><td class='mytd'>").append(apply.getToaccount()).append("</td><td class='mytd'>角色ID：</td><td class='mytd'>").append(apply.getRoleid()).append("</td></tr>")
	                             .append("<tr class='mytr'><td  class='mytd'>").append("订单总金额：").append("</td><td class='mytd'>").append(apply.getMoney()).append("</td><td class='mytd'>").append("返利总金额：").append("</td><td class='mytd'>").append(apply.getRebatemoney()).append("</td><td class='mytd'>").append("消耗总金额：").append("</td><td class='mytd'>").append(apply.getConsumemoney()).append("</td></tr>")
	                             .append("<tr class='mytr'><td  class='mytd'>").append("申请事由：").append("</td><td colspan='5' class='mytd'>").append(apply.getReason()).append("</td></tr>")
	                              .append("<tr  class='mytr'><td colspan='6'  class='mytd'  align='center'>充值详情：</td></tr>")
	                              .append("<tr class='mytr'><td colspan='6' class='mytd'>")
	                              .append("<table><tr class='mytr'><td class='mytd'>序号</td><td class='mytd'>订单号</td><td class='mytd'>充值时间</td><td class='mytd'>充值金额</td><td class='mytd'>返利比例</td><td class='mytd'>返利金额</td><td class='mytd'>消耗比例</td><td class='mytd'>消耗金额</td></tr>");
	                              for(int i=0;i<rolist.size();i++){
	                            	  RebateOrder ro = rolist.get(i);
	                            	  html.append("<tr  class='mytr'><td class='mytd'>").append(i+1).append("</td><td class='mytd'>").append(ro.getOrderid())
	                            	  . append("</td><td class='mytd'>").append(ro.getOrderTime())
	                            	  .append("</td><td class='mytd'>").append(ro.getPayMoney())
	                            	  .append("</td><td class='mytd'>").append(ro.getPercent())
	                            	  .append("%</td><td class='mytd'>").append(ro.getRebateMoney())
	                            	  .append("</td><td class='mytd'>").append(ro.getConsumePercent())
	                            	  .append("%</td><td class='mytd'>").append(ro.getConsumeMoney()).append("</td></tr>");
	                              }
	                              html.append("</td></tr></table></td></tr>")
	                               .append("<tr class='mytr'><td colspan='6'  class='mytd'></td></tr>")
	           .append("<tr  class='mytr'><td class='mytd'>外呼人：").append("</td><td class='mytd'>").append(apply.getUsername()).append("</td><td class='mytd'>申请日期：</td ><td colspan='3'  class='mytd'>").append(apply.getApplyTime()).append("</td></tr></table>")                   
	           .append(" <br><br><br>")   
		       .append(" &nbsp;&nbsp;&nbsp;迅雷牛x平台后台管理系统<br>")   
		       .append(" &nbsp;&nbsp;&nbsp;"+sdf.format(new Date()))
			   .append(" <body><html>");	 
		  return html;
	  }
}
