package com.xunlei.niux.manager.web.proxy;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.util.StringTools;


public class GameBoxPicProxy {
	private static final Logger logger = Logger.getLogger(GameBoxPicProxy.class.getName());
	private static final String baseUrl =  IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");
	private static final String gameBoxPicUrl =  IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("gameBoxPicUrl");	
	private static final GameBoxPicProxy instance = new GameBoxPicProxy();
	
	private GameBoxPicProxy(){
		
	}
	
	public static GameBoxPicProxy getInstance(){
		return instance;
	}

	public void synchPic(String picUrl, String type,String gameId,boolean isPng){
		if(StringTools.isEmpty(picUrl))return;
		String params [] = picUrl.split("/");
		File file = new File(gameBoxPicUrl+"/"+type);//如果不存在目录，则先创建目录
		if(!file.exists()){
			file.mkdirs();
		}
		if(params==null||params.length<5)return;
		System.out.println(gameBoxPicUrl+type+"/"+gameId);
		File sfile = new File(baseUrl+params[3]);
		if(!sfile.exists()){
			sfile.mkdirs();
			System.out.println("download:"+(baseUrl+params[3]+"/"+params[4]));
			download(picUrl,baseUrl+params[3]+"/"+params[4]);
		}else{
			sfile = new File(baseUrl+params[3]+"/"+params[4]);
			if(!sfile.exists()){
				System.out.println("download:"+(baseUrl+params[3]+"/"+params[4]));
				download(picUrl,baseUrl+params[3]+"/"+params[4]);
			}
		}
		copyPic(baseUrl+(params[3]+"/"+params[4]),gameBoxPicUrl+type+"/"+gameId,isPng);//新文件以游戏编号命名
	}
	
	private void download(String picUrl,String targetPicPath){
		OutputStream os = null;
		InputStream is  = null;
		try{
			URL url = new URL(picUrl);				
			File outFile = new File(targetPicPath);	
			if(!outFile.exists()){
				outFile.createNewFile();
			}
			os = new FileOutputStream(outFile);			
			is = url.openStream();				
			byte[] buff = new byte[1024];				
			while(true) {					
				int readed = is.read(buff);					
				if(readed == -1) {						
					break;					
				}					
				byte[] temp = new byte[readed];					
				System.arraycopy(buff, 0, temp, 0, readed);					
				os.write(temp);				
			}				
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				is.close();                                
				os.close();
			}catch(Exception e){
				
			}
		}
	

	}
	
	private void copyPic(String sourcePic,String targetPicPath,boolean isPng){
		String fileName = sourcePic.substring(sourcePic.lastIndexOf("/"));
		String charName = fileName.substring(fileName.indexOf("."));//文件后缀
		if(isPng){
			charName = charName.replace(".jpg", ".png");
			charName = charName.replace(".JPG", ".png");
		}
		FileInputStream fis = null;
		FileOutputStream fos = null;
		try{
			fis = new FileInputStream(sourcePic);		
			int data = fis.read();
			if(data==-1)return;
			File file = new File(targetPicPath+charName);
			if(!file.exists()){
				file.createNewFile();
			}
			fos = new FileOutputStream(file);			
			while(data != -1){
				fos.write(data);
				data = fis.read();
			}
			fos.flush();
		}catch(Exception e){
			e.printStackTrace();
			logger.error("copyPic exception.sourcePic:"+sourcePic+",targetPicPath:"+targetPicPath+",reason:"+e.getMessage());
		}finally{
			try{
				if(fos != null){
					fos.close();
					fos = null;
				}
				if(fis != null){
					fis.close();
					fis = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
}
