package com.xunlei.niux.manager.web.proxy;

import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerRole;
import com.xunlei.niux.data.vipgame.vo.CustomerUser;

public class CustomerUserProxy {

     private static final CustomerUserProxy  instance = new CustomerUserProxy();
     private static BaseSo baseBo;
     private CustomerUserProxy(){
    	 baseBo = FacadeFactory.INSTANCE.getBaseSo();
     }
     
     public static CustomerUserProxy getInstance(){
    	 return instance;
     }
     
     /**
      * 判断客户系统用户可以查到最大的vip等级
      * @param username
      * @return
      */
     public  int getVipGrade(String username){
    	 if(username == null||"".equals(username))return 0;
    	 username = username.trim();
    	 CustomerUser user = new CustomerUser();
    	 user.setUserName(username);
    	 CustomerUser cu = baseBo.findObject(user);
    	 if(cu == null)return 0;
    	 String croleId = cu.getCroleId();
    	 CustomerRole role = new CustomerRole();
    	 role.setSeqid(Long.parseLong(croleId));
    	 CustomerRole cr = baseBo.findObject(role);
    	 if(cr == null)return 0;
    	 return cr.getVipGrade().intValue();
     }
}
