package com.xunlei.niux.manager.web.proxy;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.util.CollectionUtils;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.pay.facade.FacadeFactory;
import com.xunlei.niux.data.pay.vo.DayLimitGift;
import com.xunlei.niux.data.pay.vo.MonthLimitGift;



public class CheckGiftMoneyProxy {
	

     private static final CheckGiftMoneyProxy instance = new CheckGiftMoneyProxy();
     
     private CheckGiftMoneyProxy(){
    	 
     }

     public static CheckGiftMoneyProxy getInstance(){
    	 return instance;
     }
     
     
     public int checkMoney(double giftmoney){
    	 String daytime = getNowDay();
    	 DayLimitGift query = new DayLimitGift();
    	 query.setDaytime(daytime);
    	 Page page = new Page();
    	 page.setPageNo(1);
    	 page.setPageSize(1);
    	 List<DayLimitGift> dlglist = FacadeFactory.INSTANCE.getDayLimitGiftBo().findDayLimitGift(query, page);
    	 if(!CollectionUtils.isEmpty(dlglist)){
    		 DayLimitGift dlg = dlglist.get(0);
    		 if(dlg.getIslimit().intValue()==1){
    			 return 1;//每日受限
    		 }
    		 if(dlg.getMoney().doubleValue()+giftmoney>dlg.getLimitMoney().doubleValue()){
    			 return 1;//每日受限
    		 }
    	 }
    	 String month = daytime.substring(0,7);
    	 MonthLimitGift mquery = new MonthLimitGift();
    	 mquery.setMonth(month);
    	 List<MonthLimitGift> mlglist = FacadeFactory.INSTANCE.getMonthLimitGiftBo().findMonthLimitGift(mquery, page);
    	 if(!CollectionUtils.isEmpty(mlglist)){
    		 MonthLimitGift mlg = mlglist.get(0);
    		 if(mlg.getIslimit().intValue()==1){
    			 return 2;//每月受限
    		 }
    		 if(mlg.getMoney().doubleValue()+giftmoney>mlg.getLimitMoney().doubleValue()){
    			 return 2;//每月受限
    		 }
    	 }
    	return 0;
     }
     
     private String getNowDay(){
    	 SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    	 return sdf.format(new Date());
     }
     
     
}
