package com.xunlei.niux.manager.web.proxy;

import com.xunlei.niux.manager.web.util.HttpClientUtil;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class BigDataDqProxy {

    private static final Logger logger = Logger.getLogger(BigDataDqProxy.class.getName());
    private static String DQ_URL_LAST_LOGIN_TIME = "http://dq2.niu.xunlei.com/act/getLastTime";
    private static String DQ_URL_LOGIN_DAYS = "http://dq2.niu.xunlei.com/act/getLoginDays";
    private static String DQ_URL_FIRST_PAY_TIME = "http://dq2.niu.xunlei.com/act/getFirstPayTime";
    private static String DQ_URL_FIRST_LOGIN_TIME = "http://dq2.niu.xunlei.com/act/getFirstLoginTime";

    /**
     * 最后登陆时间
     */
    public static String getLastLoginTime(Long uid){
        String result="";
        try {
            String url = DQ_URL_LAST_LOGIN_TIME+"?userId="+uid;
            logger.info("getLastLoginTime查找uid"+url);
            String rr = HttpClientUtil.get(url);
            logger.info("getLastLoginTime查找uid返回"+rr);
            JSONObject uidJson = new JSONObject(rr);
            String rtn = uidJson.getString("rtn");
            if(!"0".equals(rtn)){
                return "";
            }
            JSONObject dataJson = new JSONObject(uidJson.getString("data"));
            result= dataJson.getString("lastLoginTime");
        } catch (Exception e) {
            logger.error("getLastLoginTime Exception ",e);
        }
        return result;
    }
    /**
     * 时间范围内查找登陆天数
     */
    public static Integer getLoginDays(Long uid, String from, String to){
        Integer result=0;
        try {
            String url = DQ_URL_LOGIN_DAYS+"?userId="+uid+"&from="+from+"&to="+to;
            logger.info("getLoginDays查找uid"+url);
            String rr = HttpClientUtil.get(url);
            logger.info("getLoginDays查找uid返回"+rr);
            JSONObject uidJson = new JSONObject(rr);
            String rtn = uidJson.getString("rtn");
            if(!"0".equals(rtn)){
                return 0;
            }
            JSONObject dataJson = new JSONObject(uidJson.getString("data"));
            result= dataJson.getJSONArray("days").length();
        } catch (Exception e) {
            logger.error("getLoginDays Exception ",e);
        }
        return result;
    }


    /**
     * 首冲时间
     */
    public static String getFirstPayTime(Long uid){
        String result="";
        try {
            String url = DQ_URL_FIRST_PAY_TIME+"?userId="+uid;
            logger.info("getFirstPayTime查找uid"+url);
            String rr = HttpClientUtil.get(url);
            logger.info("getFirstPayTime查找uid返回"+rr);
            JSONObject uidJson = new JSONObject(rr);
            String rtn = uidJson.getString("rtn");
            if(!"0".equals(rtn)){
                return "";
            }
            JSONObject dataJson = new JSONObject(uidJson.getString("data"));
            result= dataJson.getString("firstPayTime");
        } catch (Exception e) {
            logger.error("getFirstPayTime Exception ",e);
        }
        return result;
    }

    /**
     * 首登时间
     */
    public static String getFirstLoginTime(Long uid){
        String result="";
        try {
            String url = DQ_URL_FIRST_LOGIN_TIME+"?userId="+uid;
            logger.info("getFirstLoginTime查找uid"+url);
            String rr = HttpClientUtil.get(url);
            logger.info("getFirstLoginTime查找uid返回"+rr);
            JSONObject uidJson = new JSONObject(rr);
            String rtn = uidJson.getString("rtn");
            if(!"0".equals(rtn)){
                return "";
            }
            JSONObject dataJson = new JSONObject(uidJson.getString("data"));
            result= dataJson.getString("firstLoginTime");
        } catch (Exception e) {
            logger.error("getFirstLoginTime Exception ",e);
        }
        return result;
    }


}
