package com.xunlei.niux.manager.web.proxy;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.workflow.WorkFlow;
import com.xunlei.niux.data.vipgame.vo.workflow.WorkRecord;
import com.xunlei.niux.data.vipgame.vo.workflow.WorkUser;
import com.xunlei.niux.manager.web.util.EmailSender;
import com.xunlei.util.StringTools;

public class AbstractBaseAuth implements IBaseAuth {

private static final Logger logger = Logger.getLogger(BaseAuthImpl001.class.getName());
	
	private BaseSo baseSo;
	public AbstractBaseAuth(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
	}

    public boolean isSpecialDisplayOrder(String flowNo, int displayOrder, String account) {
        WorkUser user = new WorkUser();
        user.setFlowNo(flowNo);
        user.setAccount(account);
        user.setDisplayOrder(displayOrder);
        WorkUser wu = baseSo.findObject(user);
        return wu != null;
    }

	public String getLastChecker(String flowNo, String wporderid) {
		WorkRecord record = new WorkRecord();
		record.setFlowNo(flowNo);
		record.setWporderid(wporderid);
		Page page = new Page();
		page.addOrder("checkTime", OrderType.DESC);
		List<WorkRecord> wrlist = baseSo.findObjects(record, page);
		if(wrlist !=null&&wrlist.size()>0){
			return wrlist.get(0).getChecker();
		}
		return null;
	}
	
	public String getNextChecker(String flowNo,String wporderid){
		WorkUser user = new WorkUser();
		user.setFlowNo(flowNo);
		Page page = new Page();
		page.addOrder("displayOrder", OrderType.ESC);
		List<WorkUser> wulist = baseSo.findObjects(user, page);
		
		WorkRecord record = new WorkRecord();
		record.setFlowNo(flowNo);
		record.setWporderid(wporderid);
		Page page2 = new Page();
		page2.addOrder("checkTime", OrderType.DESC);
		List<WorkRecord> wrlist = baseSo.findObjects(record, page2);
		if(wrlist==null||wrlist.size()==0)return wulist.get(0).getAccount();//如果前面没有审核人，则下个审核人是第一个人
		
		WorkRecord wr = wrlist.get(0);
		if(!wr.getIsvalid())return wulist.get(0).getAccount();//如果最后一个审核人无效，则下个审核人是第一个人
		String account = wr.getChecker();
		for(WorkUser wu :wulist){
			if(wu.getAccount().trim().equals(account.trim())){
				int displayorder = wu.getDisplayOrder();
				if(!checkNextChecker(wulist,displayorder)){//如果是最后一个审核人
					return null;
				}else{
					return wulist.get(displayorder).getAccount();
				}
			}
		}	
		return null;
	}
	
	private boolean checkNextChecker(List<WorkUser> wulist,int displayorder){
		for(WorkUser wu:wulist){
			if(wu.getDisplayOrder().intValue()>displayorder){
				return true;
			}
		}
		return false;
	}
	
	public void sendMail(String time,String title,StringBuffer content,String ...receivers) throws Exception {		
		 StringBuffer html = new StringBuffer();
		 html.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html\"; charset=\"gb2312\"/></head>")
	       .append("<style type=\"text/css\">")
	       .append("body {")
	       .append("font: 75%/1.6 \"Myriad Pro\", Frutiger, \"Lucida Grande\", \"Lucida Sans\", \"Lucida Sans Unicode\", Verdana, sans-serif;}")
	       .append(" a {color: #c75f3e;}")
	       .append("#mytable {border-collapse: collapse;width: 80%;border: 1px solid #666;}")
           .append(".mythead {background: #6d86d6;border-top: 1px solid #a5a5a5;border-bottom: 1px solid #a5a5a5;}")
           .append("#title {font-size: 1.2em;font-weight: bold;margin: 1em 0;padding: 0;text-align:center;}")
           .append("th {font-weight: normal;text-align: left;}")
           .append("th,.mytd {padding: 0.1em 1em;border:1px solid #ccc;}")
           .append("tr.mytr {background-color:#edf5ff;}")
           .append("tr.mytr:hover {background-color: transparent;color: inherit;}")
           .append("col {border-right: 1px solid #ccc;}")
           .append(".red{color:red;font-weight:lighter;border:0px;}")
           .append("</style><body id=\"thisbody\">")
           .append(content)          
           .append(" <br><br><br>")   
	       .append(" &nbsp;&nbsp;&nbsp;迅雷牛x平台后台管理系统<br>")   
	       .append(" &nbsp;&nbsp;&nbsp;"+time)
		   .append(" <body><html>");	 
		   EmailSender.sendMail(receivers, title, html.toString());
	}
	
	public void record(String flowNo, String wporderid, String account,String time,
			int status, String reason) {
			WorkRecord wr = new WorkRecord();
			wr.setFlowNo(flowNo);
			wr.setWporderid(wporderid);
			wr.setChecker(account);
			wr.setCheckTime(time);
			wr.setStatus(new Integer(status));
            wr.setReason(reason);
            wr.setIsvalid(true);
            baseSo.addObject(wr);
	}
    
	/**
	 * 将指定订单之前的审核记录，设置成无效
	 * @param flowNo
	 * @param wporderid
	 */
	public void invalidRecord(String flowNo, String wporderid){
		WorkRecord wr = new WorkRecord();
		wr.setFlowNo(flowNo);
		wr.setWporderid(wporderid);
		List<WorkRecord> wrlist = baseSo.findObjects(wr, new Page());
		if(wrlist != null&&wrlist.size()>0){
			for(WorkRecord record:wrlist){
				record.setIsvalid(false);
				baseSo.updateObjectById(record);
			}
		}
	}
	
	public WorkUser getWorkUser(String flowNo,String account){
		  WorkUser user = new WorkUser();
          user.setFlowNo(flowNo);
          user.setAccount(account);           
          return baseSo.findObject(user);
	}
	
	public boolean isLastChecker(String flowNo, String wporderid, String account) {
		  WorkUser user = new WorkUser();
          user.setFlowNo(flowNo);
          user.setAccount(account);           
          WorkUser wu = baseSo.findObject(user);
         
          WorkUser user2 = new WorkUser();
          user2.setFlowNo(flowNo);
          user2.setDisplayOrder(wu.getDisplayOrder()+1);
          WorkUser wu2 = baseSo.findObject(user2);
          if(wu2 == null)return true;
		return false;
	}
	
	public void checkUser(String flowNo,String wporderid,String account) throws Exception {
		   logger.info("check user flowNo:"+flowNo+",wporderid:"+wporderid+",account:"+account);
		   if(StringTools.isEmpty(flowNo)){
			   throw new XLRuntimeException("审核流程编号为空");
		   }
		   if(StringTools.isEmpty(account)){
			   throw new XLRuntimeException("审核账号为空");
		   }
		   account = account.trim();
           WorkFlow flow = new WorkFlow();
           flow.setFlowNo(flowNo);
           WorkFlow wf = baseSo.findObject(flow);
           if(wf == null){
        	   throw new XLRuntimeException("该功能审核流程不能为空，请先配置审核流程");
           }
           WorkUser user = new WorkUser();
           user.setFlowNo(flowNo);
           user.setAccount(account);           
           WorkUser wu = baseSo.findObject(user);
           if(wu == null){
        	   throw new XLRuntimeException("您没有该功能的审核权限");
           }
           WorkRecord record = new WorkRecord();
           record.setFlowNo(flowNo);
           record.setWporderid(wporderid);
           record.setIsvalid(true);
           List<WorkRecord> wrlist = baseSo.findObjects(record, new Page());
           //查询该审核人前面的审核人
           WorkUser user2 = new WorkUser();
           user2.setFlowNo(flowNo);
           user2.setDisplayOrder(wu.getDisplayOrder().intValue()-1);
           List<WorkUser> wu2List = baseSo.findObjects(user2, new Page());
           boolean flag = false;
           for(WorkRecord wr:wrlist){
        	   if(wr.getChecker().equals(account)){
        		   throw new XLRuntimeException("您已经审核过了，请不要重复审核");
        	   }
        	   if(findChecker(wu2List,wr.getChecker())){       		   
	        		 flag = true;
        	   }        	   
           }
           if(!CollectionUtils.isEmpty(wu2List)&&!flag){
        	   throw new XLRuntimeException("您前面的人还没有审核");
           }
           logger.info("check user success flowNo:"+flowNo+",wporderid:"+wporderid+",account:"+account);
	}
	
	
	private boolean findChecker (List<WorkUser> wuList,String checker){
		if(CollectionUtils.isEmpty(wuList))return false;
		for(WorkUser wu:wuList){
			if(wu.getAccount().trim().equals(checker))return true;
		}
		return false;
	}
	
	public String getFirstChecker(String flowNo, String wporderid){
		WorkUser user = new WorkUser();
		user.setFlowNo(flowNo);
		Page page = new Page();
		page.addOrder("displayOrder", OrderType.ESC);
		List<WorkUser> wulist =  baseSo.findObjects(user, page);
		if(wulist == null||wulist.size()==0)return null;
		return wulist.get(0).getAccount();
	}
	
	public String getEmailFromName(String account){
		if(account == null||"".equals(account))return null;
		return account+"@xunlei.com";
	}

	@Override
	public boolean checkUser(String flowNo, int order, String account) {
		// TODO Auto-generated method stub
		return false;
	}
}
