package com.xunlei.niux.manager.web.model.weixin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.model.vo.WeiQuanInfo;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.SignMd5;
import com.xunlei.util.StringTools;


/**
 * 微信维权信息
 * @author lujianming
 * 2014-09-26
 */
public class WeiQuanInfoManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(WeiQuanInfoManagedBean.class.getName());
    private BaseSo baseSo;
    private String weiquanUpdateUrl = "http://10.1.3.41:8080/weixin/weiquanupdate.do?";
    private String weiquanUpdateUrl2 = "http://10.1.3.40:8080/weixin/weiquanupdate.do?";
//    private String weiquanUpdateUrl = "http://121.14.82.231/weixin/weiquanupdate.do?";
    private String geturlkey = "3EDU8kYnz3au8mPPnd3KWEL2uhy7lDlDD2345dl6";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	public WeiQuanInfoManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
	}
	
	/**
	 * 
	 * @return
	 */
	public String getQueryWeiQuanInfoList(){		
        this.authenticateRun();//验证运行权限
        String status = findParameter("status");
        String msgType = findParameter("msgType");
        String feedBackId = findParameter("feedBackId");
        logger.info("[getQueryWeiQuanInfoList]status:"+status+",msgType:"+msgType+",feedBackId:"+feedBackId);
        PagedFliper pagedFliper = this.getFliper();    
        int count = 0;
        
        if(StringUtils.isEmpty(status)){
        	status = "0";
        }
        
        if(StringUtils.isEmpty(msgType)){
        	msgType = "request";
        }
        
        if(!StringUtils.isEmpty(feedBackId)){
        	count = baseSo.count("select count(*) from weiquaninfo where status=? and MsgType=? and FeedBackId=?", new String[]{status,msgType,feedBackId});
        }else{
        	count = baseSo.count("select count(*) from weiquaninfo where status=? and MsgType=?", new String[]{status,msgType});
        }
        
        logger.info("[getQueryWeiQuanInfoList]count:"+count);
        
        pagedFliper.setRecordCount(count);
        List<WeiQuanInfo> list = new ArrayList<WeiQuanInfo>();  
        int pageSize = pagedFliper.getPageSize();
        int pageNo = pagedFliper.getPageNo();
        int index = (pageNo - 1) * pageSize;
        if (count > 0) {
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("operateTime", OrderType.DESC);
            if(!StringUtils.isEmpty(feedBackId)){
            	list = baseSo.executeQuery(WeiQuanInfo.class, 
            			"select * from weiquaninfo where status=? and MsgType=? and FeedBackId=?  limit " + index + "," + pageSize, 
            			Arrays.asList(new String[]{status,msgType,feedBackId}));
            }else{
            	list = baseSo.executeQuery(WeiQuanInfo.class, 
            			"select * from weiquaninfo where status=? and MsgType=?  limit " + index + "," + pageSize, 
            			Arrays.asList(new String[]{status,msgType}));
            }
            
            logger.info("[getQueryWeiQuanInfoList]list:"+(list != null ? list.size() : null));
            
            //转化一下时间格式
            for(WeiQuanInfo info : list){
            	info.setInputby(info.getInputby() == null ? "" : info.getInputby());
            	info.setInputtime(info.getInputtime() == null ? "" : sdf.format(new Date(Long.parseLong(info.getInputtime() + "000"))));
            	info.setEditby(info.getEditby() == null ? "" : info.getEditby());
            	info.setEdittime(info.getEdittime() == null ? "" : sdf.format(new Date(Long.parseLong(info.getEdittime() + "000"))));
            }
            
        } 
        Sheet<WeiQuanInfo> sheet = new Sheet<WeiQuanInfo>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}

	
	public String updateWeiQuanInfo(){
		logger.info("[updateWeiQuanInfo]begin update");
		this.authenticateRun();//验证运行权限
		try{
			    String delseqids = findParameter("delseqids");	
			    logger.info("[updateWeiQuanInfo]delseqids:"+delseqids);
				String ids[] = delseqids.split(",");
				for(String id:ids){		
					if(StringTools.isEmpty(id))continue;
					id = id.trim();
					WeiQuanInfo info = baseSo.findById(WeiQuanInfo.class, id);
					
					String sign = SignMd5.tomd5(info.getFeedBackId() + geturlkey+ info.getOpenId());
					String responseText = null;
					StringBuffer sb =  null;
							
					try{
						
						sb = new StringBuffer(weiquanUpdateUrl);
						sb.append("sign=").append(sign).append("&openid=").append(info.getOpenId()).append("&feedbackid=").append(info.getFeedBackId());
						logger.info("[updateWeiQuanInfo]request:"+sb);
						responseText = HttpClientUtil.get(sb.toString());
						logger.info("[updateWeiQuanInfo]request:"+sb+",responseText:"+responseText);
					}catch(Exception e){
						sb = new StringBuffer(weiquanUpdateUrl2);
						sb.append("sign=").append(sign).append("&openid=").append(info.getOpenId()).append("&feedbackid=").append(info.getFeedBackId());
						logger.info("[updateWeiQuanInfo2]request:"+sb);
						responseText = HttpClientUtil.get(sb.toString());
						logger.info("[updateWeiQuanInfo2]request:"+sb+",responseText:"+responseText);
					}
					
					if(!"0".equals(responseText)){
						mergeJsmessage("update"+info.getFeedBackId()+"failed,reason:" + responseText);
					}
					
					//更新修改人
					UserInfo user=this.currentUserInfo();
					info.setEditby(user.getTrueName());
					info.setEdittime(String.valueOf(System.currentTimeMillis() / 1000));
					baseSo.updateObjectById(info);
				}				    		
		}catch(Exception e){
			logger.error("[updateWeiQuanInfo]update failed", e);
			mergeJsmessage("[updateWeiQuanInfo]update failed,reason:" + e.getMessage());
		}		
		return "";
	}

}
