package com.xunlei.niux.manager.web.model.vip;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vip.facade.FacadeFactory;
import com.xunlei.niux.data.vip.vo.UserRebateRecord;
import com.xunlei.niux.data.vip.vo.UserRebateUseRecord;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.PageUtil;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 13-9-25
 * Time: 下午2:16
 * To change this template use File | Settings | File Templates.
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_USERREBATEUSERECORD)
public class UserRebateUseRecordBean extends BaseManagedBean {
    private final Logger logger = Logger.getLogger(this.getClass());

    /**
     * 查询用户返利信息
     * @return
     */
    public String getUserRebateUseRecordList(){
        logger.debug("开始用户返利使用记录查询");
        this.authenticateRun();//验证运行权限
        UserRebateUseRecord userRebateUseRecord=this.findBean(UserRebateUseRecord.class,"userrebateuserecord");
        if(userRebateUseRecord!=null){
            logger.debug("user Rebate Use RecordNO "+userRebateUseRecord.getUseRecordNo());
        }
        PagedFliper pagedFliper =this.getFliper();
        int count= FacadeFactory.INSTANCE.getBaseBo().countObject(userRebateUseRecord);
        List<UserRebateUseRecord> list=new ArrayList<UserRebateUseRecord>();

        if(count>0){
            Page page= PageUtil.formatPage(pagedFliper, "useRecordNo", "desc");
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            list=FacadeFactory.INSTANCE.getBaseBo().findObjects(userRebateUseRecord,page);
        }
        Sheet<UserRebateUseRecord> sheet=new Sheet<UserRebateUseRecord>(count,list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }
}
