package com.xunlei.niux.manager.web.model.vip;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vip.vo.UserRebateRecord;
import com.xunlei.niux.data.vip.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.PageUtil;
import org.apache.log4j.Logger;

import javax.faces.model.SelectItem;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: jia
 * Date: 13-9-24
 * Time: 下午3:45
 * To change this template use File | Settings | File Templates.
 */

@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_USERREBATERECORD)
public class UserRebateRecordBean extends BaseManagedBean {
    private final Logger logger = Logger.getLogger(this.getClass());

    /**
     * 查询用户返利信息
     * @return
     */
    public String getUserRebateRecordList(){
        logger.debug("开始用户返利查询");
        this.authenticateRun();//验证运行权限
        UserRebateRecord userRebateRecord=this.findBean(UserRebateRecord.class,"userrebaterecord");
        if(userRebateRecord!=null){
            logger.debug("user Rebate RecordNO "+userRebateRecord.getUseRecordNo());
        }
        PagedFliper pagedFliper =this.getFliper();
        int count= FacadeFactory.INSTANCE.getBaseBo().countObject(userRebateRecord);
        List<UserRebateRecord> list=new ArrayList<UserRebateRecord>();

        if(count>0){
            Page page= PageUtil.formatPage(pagedFliper, "recordTime", "desc");
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            list=FacadeFactory.INSTANCE.getBaseBo().findObjects(userRebateRecord,page);
        }
        Sheet<UserRebateRecord> sheet=new Sheet<UserRebateRecord>(count,list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }
}

