package com.xunlei.niux.manager.web.model.vicclub;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.vicclub.VicClubCustomerService;
import com.xunlei.niux.data.vipgame.vo.vicclub.VicClubStarRecord;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.server.common.exception.XLException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

public class VicClubStarRecordManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(VicClubStarRecordManagedBean.class.getName());


    public String getQueryData(){
        this.authenticateRun();//验证运行权限
        VicClubStarRecord bean = findBean(VicClubStarRecord.class,"vicclubstarrecord");
        if(bean==null)bean=new VicClubStarRecord();
        PagedFliper pagedFliper = this.getFliper();
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(bean);
        pagedFliper.setRecordCount(count);

        List<VicClubStarRecord> list = new ArrayList<VicClubStarRecord>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("seqid", OrderType.DESC);

            list = FacadeFactory.INSTANCE.getBaseSo().findObjects(bean, page);
        }
        Sheet<VicClubStarRecord> sheet = new Sheet<VicClubStarRecord>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

}
