package com.xunlei.niux.manager.web.model.thread;

import java.util.ArrayList;
import java.util.List;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.RebateApply;

public class RebateTask implements Runnable{
	
	private RebateApply apply;
	
	public RebateTask(RebateApply apply){
		this.apply = apply;
	}

	@Override
	public void run() {
        //获取改用户当月最大申请次数
        String getMonthCountsql = " SELECT count(*)  FROM rebateapply WHERE checkstatus =1 and aporderid <> ? and uid=? AND DATE_FORMAT(applytime,'%Y-%m') = DATE_FORMAT(now(),'%Y-%m')";
        int monthCount = FacadeFactory.INSTANCE.getBaseSo().count(getMonthCountsql, new String[]{apply.getAporderid(),apply.getUid()});
        apply.setMonthCount(monthCount);

        //获取改用户历史最大申请次数
        String sql="select count(*) from rebateapply where checkstatus=1 and aporderid<> ? and uid=?";
        int totalCount = FacadeFactory.INSTANCE.getBaseSo().count(sql, new String[]{apply.getAporderid(),apply.getUid()});
        apply.setTotalCount(totalCount);
		FacadeFactory.INSTANCE.getBaseSo().updateObjectById(apply);
	}

}
