package com.xunlei.niux.manager.web.model.thread;


import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.pay.vo.PayDetailOK;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.*;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.model.RebateApplyManagedBean;
import com.xunlei.niux.manager.web.model.lychat.LyChatEmailSender;
import com.xunlei.niux.manager.web.model.tasks.ConcurrentExecutor;
import com.xunlei.niux.manager.web.proxy.BaseAuthFactory;
import com.xunlei.niux.manager.web.proxy.IBaseAuth;
import com.xunlei.niux.manager.web.proxy.RebateApplyProxy;
import com.xunlei.niux.manager.web.util.Constant;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.SignUtil;
import com.xunlei.niux.manager.web.vo.NiuxEmailVo;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.util.CollectionUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;

public class RebateOrderPassBatchThread implements Runnable {

    private static final Logger logger = Logger.getLogger(RebateOrderPassBatchThread.class.getName());
    private static final String bizNo = "dkhfdjq";//大客户返代金券业务编号
    private static final String actNo = "customercash";//大客户返代金券活动编号
    private static String generatePrivateKey="wlssfldflinlfslfs";
    private static final String VOUCHERURL = EnvPropertyUtil.loadProperty("niux", "voucherurl");
    private static String yuanbaourl="http://paysvr.niu.xunlei.com:8090";
    private static String privateKey="89oi8=9kmikmnjjdls;dkkks-xkkoldl";

    private List<RebateApply> raList = new ArrayList<RebateApply>();

    private static Map<Integer,String> typeMap = RebateApplyManagedBean.typeMap;

    private String currentUser;
    private String nowtime;

    public RebateOrderPassBatchThread(List<RebateApply> raList, String currentUser) {
        this.raList = raList;
        this.currentUser = currentUser;
        this.nowtime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    @Override
    public void run() {
        for(RebateApply ra : raList){
            try{
                if(ra.getCheckstatus()==1){
                    goLast(ra);
                }else{
                    goNotLast(ra);
                }
            }catch (Exception e){
                logger.error("订单异常"+ra.getAporderid(),e);
            }
        }

    }

    private void goNotLast(RebateApply ra) throws Exception {
        boolean hasYuanBao = ra.getRebateType()!=null && ra.getRebateType().contains("y");
        boolean isZengSongBuChang = "4".equals(ra.getApplyType());
        String FLOWNO = (hasYuanBao)? Constant.ORDERFLOWNO:Constant.GIFTFLOWNO;
        if(isZengSongBuChang){
            if(hasYuanBao){
                FLOWNO = Constant.ORDERFLOWNO;
            }else{
                FLOWNO = Constant.GIFTFLOWNO;
            }
        }
        IBaseAuth auth = BaseAuthFactory.getBaseAuth(FLOWNO);
        auth.record(FLOWNO, ra.getAporderid(), currentUser, nowtime, 1, "");
    }

    private void goLast(RebateApply ra) throws Exception{
        BaseSo baseSo = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo();

        StringBuffer content = new StringBuffer();
        if(4==ra.getApplyType()){//如果返利类型是赠送补偿返利
            String orderid = ra.getOrderid();
            String gameid = ra.getGameid();
            if(StringTools.isEmpty(gameid)){
                gameid = gameid.substring(1);//充值接口游戏编号为5位的
            }
            if(ra.getPaymoney()>0){
                giveOutYuanBao(ra.getToaccount(),  //调用直冲接口
                        gameid,
                        ra.getServerid(),
                        ra.getRoleid(),
                        orderid,
                        "applySystem",
                        new Double(ra.getPaymoney()).intValue());
            }

            //更新返利笔数和返利总金额
            CustomerDetailQuery cdq = new CustomerDetailQuery();
            cdq.setUid(ra.getUid());
            CustomerDetailQuery customer = baseSo.findObject(cdq);

            if(customer != null){
                customer.setRebateCount(customer.getRebateCount()+1);
                long cmoney = customer.getRebateMoney()==null?0:customer.getRebateMoney().longValue();
                long rmoney = ra.getPaymoney()==null?0:ra.getPaymoney().longValue();
                customer.setRebateMoney(cmoney+rmoney);
                baseSo.updateObjectById(customer);
            }
            //更新外呼记录中的充值总金额
            RebateApply rebateApply  = new RebateApply();
            rebateApply.setCrid(ra.getCrid());
            rebateApply.setCheckstatus(new Integer(1));//审核通过的订单
            List<RebateApply> ralist = baseSo.findObjects(rebateApply, new Page());
            double allmoney = 0;
            double rebatemoney = 0;
            for(RebateApply raa:ralist){
                allmoney +=raa.getMoney();
                rebatemoney += raa.getPaymoney();
            }
            CallRecord call = new CallRecord();
            call.setSeqid(Long.parseLong(ra.getCrid()));
            CallRecord callRecord = baseSo.findObject(call);
            if(callRecord != null){
                callRecord.setMoney(new Double(allmoney).longValue());
                callRecord.setRebateMoney(new Double(rebatemoney).longValue());
                callRecord.setRebateCount((ralist==null?0:ralist.size()));
                baseSo.updateObjectById(callRecord);
            }
        }else{
            if(ra.getRebateType() .indexOf("y")!=-1){//如果返利形式包含元宝
                //自动生成一个订单
                List<String> plist = new ArrayList<String>();
                plist.add(ra.getAporderid());
                RebateOrder ro = new RebateOrder();
                ro.setAporderid(ra.getAporderid());
                Page page = new Page();
                page.addOrder("orderid", OrderType.DESC);
                String payOrderid = baseSo.findObjects(ro,page).get(0).getOrderid();
                PayDetailOK payDetailOK = new PayDetailOK();
                payDetailOK.setOrderid(payOrderid);
                PayDetailOK paydetailok = com.xunlei.niux.data.pay.facade.FacadeFactory.INSTANCE.getPayDetailOkBo().findPayDetailOk(payDetailOK, new Page()).get(0);
                paydetailok.setSeqid(null);
                paydetailok.setOrderid(ra.getOrderid());
                paydetailok.setOrderidstatus("Y");
                paydetailok.setNoticeVip("Y");
                paydetailok.setNiuxactno("by_hand");
                paydetailok.setGiftFlag("1");
                paydetailok.setPaycode("03");
                paydetailok.setGoodstimes("1");
                paydetailok.setServerid(ra.getServerid());
                paydetailok.setUnitprice(ra.getPaymoney()+"");
                paydetailok.setPayMondey(new Double(0));
                paydetailok.setTotalmoney(ra.getPaymoney()+"");
                paydetailok.setSuccesstime("");
                paydetailok.setEditby(currentUser);
                paydetailok.setEdittime(nowtime);
                paydetailok.setVouchers("");
                paydetailok.setVouchersMoney(new Double(0));
                paydetailok.setOrdertime(com.xunlei.common.util.DatetimeUtil.now());
                paydetailok.setChargeSuccessTime(com.xunlei.common.util.DatetimeUtil.now());

                if(3==ra.getApplyType()){//消耗返利
                    paydetailok.setOriginalOrderid(paydetailok.getOriginalOrderid()+"_c");//消耗返利
                }else {//充值返利
                    //按默认的规则
                }

                //如果是魔域，则必须分为50 、10份
                if("00001".equals(paydetailok.getGameid())||"000001".equals(paydetailok.getGameid())){
                    double total = Double.parseDouble(paydetailok.getTotalmoney());
                    if(total%50==0){
                        paydetailok.setGoodstimes(new Double((total/50)).intValue()+"");
                        paydetailok.setUnitprice("50");
                    }else{
                        paydetailok.setGoodstimes(new Double((total/10)).intValue()+"");
                        paydetailok.setUnitprice("10");
                    }
                }
                com.xunlei.niux.data.pay.facade.FacadeFactory.INSTANCE.getPayDetailOkBo().insert(paydetailok);

                //更新返利笔数和返利总金额
                CustomerDetailQuery cdq = new CustomerDetailQuery();
                cdq.setUid(ra.getUid());
                CustomerDetailQuery customer = baseSo.findObject(cdq);

                if(customer != null){
                    customer.setRebateCount(customer.getRebateCount()+1);
                    long cmoney = customer.getRebateMoney()==null?0:customer.getRebateMoney().longValue();
                    long rmoney = ra.getPaymoney()==null?0:ra.getPaymoney().longValue();
                    customer.setRebateMoney(cmoney+rmoney);
                    baseSo.updateObjectById(customer);
                }
                //更新外呼记录中的充值总金额
                RebateApply rebateApply  = new RebateApply();
                rebateApply.setCrid(ra.getCrid());
                rebateApply.setCheckstatus(new Integer(1));
                List<RebateApply> ralist = baseSo.findObjects(rebateApply, new Page());
                double allmoney = 0;
                double rebatemoney = 0;
                for(RebateApply raa:ralist){
                    allmoney +=raa.getMoney();
                    rebatemoney += raa.getPaymoney();
                }
                CallRecord call = new CallRecord();
                call.setSeqid(Long.parseLong(ra.getCrid()));
                CallRecord callRecord = baseSo.findObject(call);
                if(callRecord != null){
                    callRecord.setMoney(new Double(allmoney).longValue());
                    callRecord.setRebateMoney(new Double(rebatemoney).longValue());
                    callRecord.setRebateCount((ralist==null?0:ralist.size()));
                    baseSo.updateObjectById(callRecord);
                }
            }else{
                //更新返利笔数和返利总金额
                CustomerDetailQuery cdq = new CustomerDetailQuery();
                cdq.setUid(ra.getUid());
                CustomerDetailQuery customer = baseSo.findObject(cdq);

                if(customer != null){
                    customer.setRebateCount(customer.getRebateCount()+1);
                    baseSo.updateObjectById(customer);
                }
                //更新外呼记录中的充值总金额
                RebateApply rebateApply  = new RebateApply();
                rebateApply.setCrid(ra.getCrid());
                List<RebateApply> ralist = baseSo.findObjects(rebateApply, new Page());
                double allmoney = 0;
                for(RebateApply raa:ralist){
                    allmoney +=raa.getMoney();
                }
                CallRecord call = new CallRecord();
                call.setSeqid(Long.parseLong(ra.getCrid()));
                CallRecord callRecord = baseSo.findObject(call);
                if(callRecord != null){
                    callRecord.setMoney(new Double(allmoney).longValue());
                    callRecord.setRebateCount(ralist==null?0:ralist.size());
                    baseSo.updateObjectById(callRecord);
                }
            }
        }

        boolean hasYuanBao = ra.getRebateType()!=null && ra.getRebateType().contains("y");
        boolean isZengSongBuChang = "4".equals(ra.getApplyType());
        String FLOWNO = (hasYuanBao)? Constant.ORDERFLOWNO:Constant.GIFTFLOWNO;
        if(isZengSongBuChang){
            if(hasYuanBao){
                FLOWNO = Constant.ORDERFLOWNO;
            }else{
                FLOWNO = Constant.GIFTFLOWNO;
            }
        }
        //获取改用户当月最大申请次数
        String getMonthCountsql = " SELECT count(*)  FROM rebateapply WHERE checkstatus =1 and aporderid <> ? and uid=? AND DATE_FORMAT(applytime,'%Y-%m') = DATE_FORMAT(now(),'%Y-%m')";
        int monthCount = FacadeFactory.INSTANCE.getBaseSo().count(getMonthCountsql, new String[]{ra.getAporderid(),ra.getUid()});
        ra.setMonthCount(monthCount);

        //获取改用户历史最大申请次数
        String sql="select count(*) from rebateapply where checkstatus=1 and aporderid<> ? and uid=?";
        int totalCount = FacadeFactory.INSTANCE.getBaseSo().count(sql, new String[]{ra.getAporderid(),ra.getUid()});
        ra.setTotalCount(totalCount);


        IBaseAuth auth = BaseAuthFactory.getBaseAuth(FLOWNO);
        content.append("恭喜您，申请单号为："+ra.getAporderid()+"的"+typeMap.get(ra.getApplyType())+"订单,已经审核通过了");
        auth.record(FLOWNO, ra.getAporderid(), currentUser, nowtime, 1, "");
        String[] receivers = new String[1];

        Games games = GameCache.getInstance().getGameByGameId(ra.getGameid());
        //发送邮件通知申请者
        StringBuffer titleBuffer = new StringBuffer("【").append(typeMap.get(ra.getApplyType())).append("审核结果】").append(games.getGameName()).append("(").append(ra.getServerid()).append(")|").append(ra.getMoney()).append("|").append(ra.getUsername()).append("|").append(ra.getApplyTime());
        receivers[0]=ra.getInputBy()+"@cc.sandai.net";
        NiuxEmailVo emailVo = new NiuxEmailVo();
        emailVo.setSubject(titleBuffer.toString());
        emailVo.setContent(content.toString());
        emailVo.setAddrs(receivers);
        ConcurrentExecutor.getInstance().execute(new LyChatEmailSender(emailVo));

        if(ra.getRebateType().indexOf("D")!=-1){//如果有申请代金券，则发放代金券
            RebateVoucher voucher = new RebateVoucher();
            voucher.setAporderid(ra.getAporderid());
            List<RebateVoucher> rvlist = baseSo.findObjects(voucher, new Page());
            if(rvlist== null||rvlist.size()==0){
                throw new XLRuntimeException("代金券为空，代金券发放失败");
            }
            int index = 1;
            for(RebateVoucher rv:rvlist){
                String cdkey = getVoucher(index,ra.getUid(),rv.getBatid());//调用接口生成代金券
                rv.setCdkey(cdkey);
                baseSo.updateObjectById(rv);
                index++;
            }
            ra.setIsSuccess(true);//代金券发放成功
        }
        baseSo.updateObjectById(ra);
    }

    public static void giveOutYuanBao(final String userName,final String gameId,final String serverId,final String roleId,final String orderNo,final String actNo,final Integer unitprice){
        //签名
        Map<String,String> paramMap=new HashMap<String,String>();
        paramMap.put("gameid", gameId);
        paramMap.put("getusername", userName);
        paramMap.put("goodstimes", "1");
        paramMap.put("niuxactno", actNo);
        paramMap.put("originalorderid", orderNo);
        paramMap.put("unitprice",unitprice+"");
        paramMap.put("roleid", roleId==null?"":roleId);
        paramMap.put("serverid",serverId);
        String content=SignUtil.getSignatureContent(paramMap);
        String signMsg=SignUtil.sign(content, privateKey);
        StringBuilder sb=new StringBuilder();
        sb.append(yuanbaourl).append("/gamepaycenter/genorder?action=genorder")
                .append("&gameid=").append(gameId)
                .append("&getusername=").append(twoEncode(userName))
                .append("&serverid=").append(serverId)
                .append("&servername=").append(twoEncode(""))
                .append("&roleid=").append(twoEncode(roleId==null?"":roleId))
                .append("&rolename=").append(twoEncode(""))
                .append("&paybiz=0&chargetype=").append("S")
                .append("&unitprice=").append(unitprice).append("&goodstimes=1").append("&bankno=")
                .append("&niuxactno=").append(actNo)
                .append("&originalorderid=").append(orderNo)
                .append("&signMsg=").append(signMsg);
        String respUrl=HttpClientUtil.get(sb.toString());
        if(!(respUrl.contains("code:0")||respUrl.contains("code:1"))){
            String msg=respUrl.substring(respUrl.indexOf("'"),respUrl.lastIndexOf("'"));
            try {
                msg=URLDecoder.decode(msg, "UTF-8");
                if(msg.contains("充值账号非游戏用户")){
                    throw new NiuRuntimeException("1030", msg);
                }
            } catch (UnsupportedEncodingException e) {
                throw new NiuRuntimeException("99","字符集转换失败");
            }
            throw new NiuRuntimeException("99",msg);
        }
    }

    private static String twoEncode(String value){
        if(value==null||"".equals(value)){
            return "";
        }
        try {
            value= URLEncoder.encode(value, "UTF-8");
            return value;
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    private String getVoucher(final int index,final String one_uid,final String generateNo) throws Exception{
        StringBuffer params = new StringBuffer();
        params.append("generateNo=").append(generateNo)
                .append("&receiveUserId=").append(one_uid)
                .append("&bizNo=").append(bizNo)
                .append("&orderid=").append(getOrderId())
                .append("&actNo=").append(actNo)
                .append("&isReport=true");

        //验证数字签名是否ok
        Map<String,String> signMap=new HashMap<String, String>();
        signMap.put("generateNo", generateNo);
        signMap.put("receiveUserId", one_uid);
        signMap.put("bizNo", bizNo);
        String sign= SignUtil.sign(signMap,generatePrivateKey);
        params.append("&sign=").append(sign);
        System.out.println("getVoucher:"+VOUCHERURL+"?"+params);
        String responseText = HttpClientUtil.get(VOUCHERURL+"?"+params);
        System.out.println("getVoucher responseText:"+responseText);
        if(responseText != null){
            if(responseText.indexOf("(") !=-1){
                responseText = responseText.substring(responseText.indexOf("(")+1);
            }
            if(responseText.indexOf(")") !=-1){
                responseText = responseText.substring(0,responseText.indexOf(")"));
            }
        }
        JSONObject returnObject = new JSONObject(responseText);
        String rtn = returnObject.getString("rtn");
        if(!"0".equals(rtn)){
            throw new XLRuntimeException("从第"+index+"个代金券开始发放失败");
        }
        JSONObject dataObject = returnObject.getJSONObject("data");
        String cashNo = dataObject.getString("cashNo");
        System.out.println("responseText:"+responseText);
        return cashNo;
    }

    private String getOrderId(){
        SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMddHHmmss");
        Calendar cal =  Calendar.getInstance();
        String orderid = SDF.format(cal.getTime());
        return orderid+new Random().nextInt(100);
    }
}
