package com.xunlei.niux.manager.web.model.spreadinfoaudit;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.manager.web.client.SpreadInfoAuditClient;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.ShortUrlCreater;
import com.xunlei.niux.manager.web.vo.spreadinfoaudit.ChannelInfo;
import com.xunlei.niux.data.vipgame.vo.Spreadinfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * Created by jamesjxin on 14-7-8.
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_AUDITCHANNELINFO)
public class ChannelInfoManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(ChannelInfoManagedBean.class.getName());
    //正式地址
    private static final String DOMAIN = "http://jump.niu.xunlei.com:8080/";

    private String userId;
    private String userName;


    public String getQueryChannelInfoList() {
        String userIdParam = this.findParameter("userId");
        String userNameParam = this.findParameter("userName");

        if (StringUtils.isNotEmpty(userIdParam)) {
            userId = userIdParam;
        }

        if(StringUtils.isNotEmpty(userNameParam)){
            userName = userNameParam;
        }

        if (StringUtils.isEmpty(userId)) {
            throw new XLRuntimeException("参数userId不能为空！");
        }

        List<ChannelInfo> channelInfoList = SpreadInfoAuditClient.getListUserChnls(userId);

//        if (CollectionUtils.isEmpty(channelInfoList)) {
//            if(StringUtils.isNotEmpty(userName)){
//                addUserChannel(userName+"0");
//                channelInfoList = SpreadInfoAuditClient.getListUserChnls(userId);
//            }
//        }

        PagedFliper pagedFliper = this.getFliper();
        int count = channelInfoList.size();
        pagedFliper.setRecordCount(count);
        Sheet<ChannelInfo> sheet = new Sheet<ChannelInfo>(count, channelInfoList);
        this.mergePagedDataModel(sheet, pagedFliper);

        return "";
    }



    public String add() {
        ChannelInfo channelInfo = this.findBean(ChannelInfo.class, "auditchannelinfo");
        if (channelInfo == null) {
            throw new XLRuntimeException("用户渠道信息为空！");
        }

        addUserChannel(channelInfo.getCaption());

        return "";
    }

    private void addUserChannel(String caption){
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        UserInfo userInfo = currentUserInfo();

        Spreadinfo spreadInfo = new Spreadinfo();
        spreadInfo.setFlatno("CPS");
        spreadInfo.setSpreadTab(caption);
        try {
            spreadInfo.setAdvNo(ShortUrlCreater.createAdvNo());
        } catch (Exception e) {
            String msg = "创建AdvNo失败";
            logger.error(msg);
            throw new XLRuntimeException(msg);
        }

        spreadInfo.setStatus(true);
        spreadInfo.setInputBy(userInfo.getTrueName());
        spreadInfo.setInputTime(format.format(new Date()));
        if (StringUtils.isEmpty(spreadInfo.getShorturl())) {
            spreadInfo.setShorturl(DOMAIN + ShortUrlCreater.createShortUrl(spreadInfo.getAdvNo()));
        }
        spreadInfo.setJumpurl("http://niu.xunlei.com");
        spreadInfo.setChooseWeight(1L);

        boolean successAddChnl = SpreadInfoAuditClient.addUserChnl(userId, spreadInfo.getAdvNo(), caption);
        if(!successAddChnl){
            throw new XLRuntimeException("增加用户渠道失败！");
        }

        FacadeFactory.INSTANCE.getSpreadinfoBo().insertSpreadInfo(spreadInfo);
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}
