package com.xunlei.niux.manager.web.model.report;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.mysql.jdbc.exceptions.jdbc4.MySQLIntegrityConstraintViolationException;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.model.BlackWhiteInfoManagedBean;
import com.xunlei.niux.manager.web.model.CustomersManagedBean;
import com.xunlei.niux.manager.web.model.vo.BlackWhiteInfo;
import com.xunlei.niux.manager.web.model.vo.CustomerServers;
import com.xunlei.niux.manager.web.model.vo.ReportInfo;
import com.xunlei.niux.manager.web.proxy.JRedisProxy;
import com.xunlei.util.StringTools;


/**
 * 举报信息
 * @author lujianming
 * 2014-11-26
 */
public class ReportInfoManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(ReportInfoManagedBean.class.getName());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private BaseSo baseSo;
	
	public ReportInfoManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
	}
	
	/**
	 * 
	 * @return
	 */
	public String getQueryReportInfoList(){		
        this.authenticateRun();//验证运行权限
        String status = findParameter("status");
        String serverid = findParameter("serverid");
        String gameid = findParameter("gameid");
        logger.info("[getQueryReportInfoList]status:"+status+",serverid:"+serverid+",gameid:"+gameid);
        PagedFliper pagedFliper = this.getFliper();    
        int count = 0;
        
        ReportInfo info = new ReportInfo();
        if(!StringUtils.isEmpty(status)){
        	info.setStatus(Integer.parseInt(status));
        }
        
        if(!StringUtils.isEmpty(serverid)){
        	info.setServerid(serverid);
        }
        
        if(!StringUtils.isEmpty(gameid)){
        	info.setGameid(gameid);
        }
        
        count = baseSo.countObject(info);
        
        logger.info("[getQueryReportInfoList]count:"+count);
        
        pagedFliper.setRecordCount(count);
        List<ReportInfo> list = new ArrayList<ReportInfo>();  
        if (count > 0) {
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("time", OrderType.DESC);
            
        	list = baseSo.findObjects(info, page);
            logger.info("[getQueryReportInfoList]list:"+(list != null ? list.size() : null));
            
        } 
        Sheet<ReportInfo> sheet = new Sheet<ReportInfo>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}

	
	public String permit(){
		logger.info("[permit]begin update");
		return doAudit(1);
	}
	
	public String deny(){
		logger.info("[deny]begin update");
		return doAudit(2);
	}
	
	private String doAudit(Integer status){
		logger.info("[doAudit]begin update");
		this.authenticateRun();//验证运行权限
		//更新修改人
		UserInfo user=this.currentUserInfo();
		String auditby = user.getTrueName();
		Date nowDate = new Date();
		String audittime = sdf.format(nowDate);
		List<BlackWhiteInfo> configList = new ArrayList<BlackWhiteInfo>();
		try{
			    String delseqids = findParameter("delseqids");	
			    logger.info("[doAudit]delseqids:"+delseqids);
				String ids[] = delseqids.split(",");
				for(String id:ids){
					if(StringTools.isEmpty(id))continue;
					id = id.trim();
					ReportInfo info = baseSo.findById(ReportInfo.class, id);
					
					if(info != null){
						info.setAuditby(auditby);
						info.setAudittime(audittime);
						info.setStatus(status);

						try{
						
							//添加到黑名单
							if(status == 1){
								logger.info("[doAudit]begin update black info.info:"+info);
								String dbname = BlackWhiteInfoManagedBean.getDBName(info.getGameid());
								
								logger.info("[doAudit]update black info.dbname:"+dbname);
								if(StringUtils.isEmpty(dbname)){
									logger.info("[doAudit]update black info.dbname:"+dbname+",info.getGameid():"+info.getGameid());
//									throw new RuntimeException("未查询到被举报玩家的游戏[" + info.getGameid() + "]，不能封号，请联系管理员处理。");
									mergeJsmessage("未查询到被举报玩家的游戏[" + info.getGameid() + "]，不能封号，请联系管理员处理。");
									return "";
								}
								
								CustomerServers customerservers = new CustomerServers();
								customerservers.setServerId(info.getServerid());
								customerservers.setRoleName(URLEncoder.encode(info.getRolename(), "utf-8"));
								List<CustomerServers> list = CustomersManagedBean.getCustomerservers(customerservers, dbname);
								
								if(list == null || list.isEmpty() || list.get(0) == null || StringUtils.isEmpty(list.get(0).getUserId())){
									logger.info("[doAudit]update black info.userid:"+null+",info.getRolename():"+info.getRolename());
//									throw new RuntimeException("未查询到被举报玩家[" + info.getRolename() + "]的账号，不能封号，请联系管理员处理。");
									mergeJsmessage("未查询到被举报玩家[" + info.getRolename() + "]的账号，不能封号，请联系管理员处理。");
									return "";
								}
								
								customerservers = list.get(0);
								
								BlackWhiteInfo black = new BlackWhiteInfo();
								black.setLogininfo(customerservers.getUserId());
								black.setReason(info.getReason());
								black.setType("0");
								black.setEditor(auditby);
								black.setEdittime(String.valueOf(nowDate.getTime() / 1000));
	
								configList = new ArrayList<BlackWhiteInfo>();
								configList.add(black);
								
								try{
									BlackWhiteInfoManagedBean.addBlackWhiteInfo(configList, dbname, 1);//添加账号黑名单type ==1
									
								}catch(Exception e){
									
									if(e.getCause() instanceof MySQLIntegrityConstraintViolationException){//已添加过
										logger.warn("[doAudit] update black info MySQLIntegrityConstraintViolationException.info:"+info,e);
										BlackWhiteInfo query = new BlackWhiteInfo();
										query.setLogininfo(customerservers.getUserId());
										query.setType("0");
										List<BlackWhiteInfo> listBlack = BlackWhiteInfoManagedBean.getBlackWhiteInfos(query, dbname, 1, 1, 1);
										if(listBlack != null && !listBlack.isEmpty()){
											logger.info("[doAudit] begin update black info MySQLIntegrityConstraintViolationException.query:"+query);
											black = listBlack.get(0);
											black.setReason(info.getReason());
											black.setEditor(auditby);
											black.setEdittime(String.valueOf(nowDate.getTime() / 1000));
											black.setOverduedate("");
											BlackWhiteInfoManagedBean.updateBlackWhiteInfo(black, dbname, 1);
											logger.info("[doAudit] end update black info MySQLIntegrityConstraintViolationException.black:"+black);
										}
									}else{
										logger.error("[doAudit] update black info Exception.info:"+info,e);
										throw e;
									}
									
								}finally{

									logger.info(" add blackwhiteinfo.begin refresh cache.");
									String gameid = info.getGameid();
									String gameBlackkey = gameid + "_" + black.getLogininfo() + "_" + black.getType() + "_black";
									Calendar calendar = Calendar.getInstance();
									int minute = calendar.get(Calendar.MINUTE); 
									boolean catchresult = JRedisProxy.getInstance().set(gameBlackkey, black.getOverduedate(), (60-minute)*60);
									logger.info(" add blackwhiteinfo.end refresh cache.插入成功结果存数缓存"+ ",gameid:" + gameid + ",gameBlackkey:"+gameBlackkey+ ",catchresult:"+catchresult+",balckwhite:"+black);
								}
								
								logger.info("[doAudit]end update black info."+info.getSeqid());
							}
							
	
							//更新审批状态
							baseSo.updateObjectById(info);
						}
						catch(Exception e){
							logger.error("[doAudit]end update audit.info:"+info, e);
						}
						
					}
				}
				
		}catch(Exception e){
			logger.error("[doAudit]update failed", e);
			mergeJsmessage("[doAudit]update failed,reason:" + e.getMessage());
		}		
		
		return "";
	
		
	}

}
