package com.xunlei.niux.manager.web.model.onesign;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.onesign.MonthSign;
import com.xunlei.niux.data.vipgame.vo.onesign.OneSignDaycount;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

public class OneSignMonthSignManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(OneSignMonthSignManagedBean.class.getName());


    public String getQueryData(){
        this.authenticateRun();//验证运行权限
        MonthSign bean = findBean(MonthSign.class,"monthsign");
        if(bean==null)bean=new MonthSign();
        PagedFliper pagedFliper = this.getFliper();
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(bean);
        pagedFliper.setRecordCount(count);

        List<MonthSign> list = new ArrayList<MonthSign>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("lastSignDate", OrderType.DESC);

            list = FacadeFactory.INSTANCE.getBaseSo().findObjects(bean, page);
        }
        Sheet<MonthSign> sheet = new Sheet<MonthSign>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }


}
