package com.xunlei.niux.manager.web.model.onesign;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.onesign.MonthSignConf;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.server.common.exception.XLException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class OneSignMonthSignConfManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(OneSignMonthSignConfManagedBean.class.getName());


    public String getQueryData(){
        this.authenticateRun();//验证运行权限
        MonthSignConf bean = findBean(MonthSignConf.class,"monthsignconf");
        if(bean==null)bean=new MonthSignConf();
        PagedFliper pagedFliper = this.getFliper();
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(bean);
        pagedFliper.setRecordCount(count);

        List<MonthSignConf> list = new ArrayList<MonthSignConf>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            list = FacadeFactory.INSTANCE.getBaseSo().findObjects(bean, page);
        }
        Sheet<MonthSignConf> sheet = new Sheet<MonthSignConf>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add(){
        this.authenticateAdd();
        try{
            MonthSignConf bean = findBean(MonthSignConf.class,"monthsignconf");
            checkParams();
            bean.setSeqid(null);
            bean.setEditBy(this.currentUserLogo());
            bean.setEditTime(now());
            FacadeFactory.INSTANCE.getBaseSo().addObject(bean);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String edit(){
        this.authenticateEdit();
        try{
            MonthSignConf bean = findBean(MonthSignConf.class,"monthsignconf");
            checkParams();
            bean.setEditBy(this.currentUserLogo());
            bean.setEditTime(now());
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(bean);
        }catch(Exception e){
            logger.error("操作失败", e);
            mergeJsmessage("操作失败，原因：" + e.getMessage());
        }
        return "";
    }

    private void checkParams() throws XLException{
        MonthSignConf bean = findBean(MonthSignConf.class,"monthsignconf");
        if(bean==null){
            throw new XLRuntimeException("找不到bean");
        }
        if(StringUtils.isEmpty(bean.getActNo())
            || StringUtils.isEmpty(bean.getJinzuanSignDays())
            || StringUtils.isEmpty(bean.getNotJinzuanSignDays())
            || StringUtils.isEmpty(bean.getStartTime())
            || StringUtils.isEmpty(bean.getEndTime())){
            throw new XLRuntimeException("参数异常");
        }
        for(String day:bean.getJinzuanSignDays().split(",")){
            if(!isInteger(day))
                throw new XLRuntimeException("金钻累计天数数据异常:"+bean.getJinzuanSignDays());
        }
        for(String day:bean.getNotJinzuanSignDays().split(",")){
            if(!isInteger(day))
                throw new XLRuntimeException("非金钻累计天数数据异常:"+bean.getNotJinzuanSignDays());
        }
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }


}
