package com.xunlei.niux.manager.web.model.mobileapk.auditthread;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ApkThreadPool {

	  private static final ApkThreadPool instance = new ApkThreadPool();
	  private ThreadPoolExecutor executor;
	  private ApkThreadPool(){
		  init();
	  }
	
	  public static ApkThreadPool getInstance(){
		  return instance;
	  }
      
	  private void init(){
		  executor  = new ThreadPoolExecutor(10,20,20,TimeUnit.SECONDS,
				  new ArrayBlockingQueue<Runnable>(10),
				  new ThreadPoolExecutor.AbortPolicy()
				  );
		  
		  Runtime.getRuntime().addShutdownHook(new Thread(){
			   public void run(){
				   shutDown();
			   }
		  });
	  }

	  private void shutDown(){
		  executor.shutdown();
	  }
	  
	  public void execute(ApkTask task){
		  executor.execute(task);
	  }
}
