package com.xunlei.niux.manager.web.model.mobileapk.auditthread;


import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.CommonSpreadInfo;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.MobileGameChannelApk;
import com.xunlei.niux.manager.web.cache.ApkSpreadCache;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.Constant;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.QRCodeUtil;
import com.xunlei.niux.manager.web.util.ShortUrlCreater;

public class ApkTask implements Runnable{
    private static final String APKLINKLOCID = "1276";//手游下载中心
    private static final String APKLINKLOCID2 = "1601";//手游找游戏
    private static final String JUMPSERVERURL = "http://jump2.niu.xunlei.com:8080/";//跳转服务器域名
    private static final String DOWNLOADLOCID = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("webDownloadId");
    private static final String DOWNLOADLOCID2 = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("appDownloadId");
    private static final String DOWNLOADLOCID3 = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("allDownloadId");
	private MobileGameChannelApk apk;
	private String apkSize;
	private String gameId;
	private String version;
	
	
	public ApkTask(MobileGameChannelApk apk,String gameId,String apkSize){
		this.apk = apk;
		this.gameId = gameId;
		this.apkSize = apkSize;
	}
	
	@Override
	public void run() {
		System.out.println("========addSpreadJump start======");
		CommonSpreadInfo spreadInfo = addSpreadJump();		
	    System.out.println("========synchOffcial start======");
		synchOffcial(spreadInfo);
		System.out.println("========addSpreadJump end======");
		ApkSpreadCache.getInstance().updateCache();
		System.out.println("=========apkSpreadCache  update============");
	}


	/**
	 * 同步最新的apk到官网
	 */
	private void synchOffcial(CommonSpreadInfo spreadInfo){		
		this.version = getVersion();
		updateDownLink(spreadInfo);
		addTemplate();
	}
	
	/**
	 * 添加跳转信息
	 */
	private CommonSpreadInfo addSpreadJump(){
		CommonSpreadInfo csi = null;
		
		try{
			this.version = getVersion();//没有版本信息
		}catch(Exception e){
			System.out.println("========addSpreadJump start======"+e);
		}
		
		try{
			deleteInfos();
			csi = new CommonSpreadInfo();
			csi.setAdvNo(apk.getChannelId());
			csi.setJumpType(Constant.APK_JUMP_TYPE);
			csi.setGameId(gameId);			
			String jumpAdvNo = getJumpAdvNo();
			csi.setJumpAdvNo(jumpAdvNo);
//			csi.setShortUrl(Constant.APK_JUMP_BASE_URL+ ShortUrlCreater.createShortUrl(jumpAdvNo));
			csi.setShortUrl(Constant.APK_JUMP_BASE_URL + gameId + "/" + apk.getChannelId());
			csi.setJumpUrl(apk.getDownLoadLink());
			String muliPhotoUrl = getMuliPhotoUrl(csi.getAdvNo(),version,gameId,apk.getDownLoadLink());
			csi.setMuliPhotoUrl(muliPhotoUrl);
			csi.setVersion(version);
			csi.setIsValid(true);
			csi.setRecordTime(DateUtil.formatNowByDefault());
			FacadeFactory.INSTANCE.getBaseSo().addObject(csi);
		}catch(Exception e){
			e.printStackTrace();
		}
		return csi;
	}
	
	/**
	 * 生成新二维码图片
	 * @return
	 */
	private String getMuliPhotoUrl(String advNo,String version,String gameId,String content){
		Games games = GameCache.getInstance().getGameByGameId(gameId);
		String gameNo = games.getGameNo()==null?"":games.getGameNo();
		return QRCodeUtil.makeJumpApkMultiFile(advNo, version, gameId, gameNo,content);
	}
	
	/**
	 * 每个APK（相同游戏相同渠道号）只保留最新版本
	 */
	private void deleteInfos(){
		CommonSpreadInfo  query = new CommonSpreadInfo();
		query.setAdvNo(apk.getChannelId());
		query.setGameId(gameId);
//		query.setVersion(version);
		query.setShortUrl(Constant.APK_JUMP_BASE_URL + gameId + "/" + apk.getChannelId());
		List<CommonSpreadInfo> infos = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
		for(CommonSpreadInfo info : infos){
			FacadeFactory.INSTANCE.getBaseSo().deleteById(CommonSpreadInfo.class, info.getSeqId());
		}
	}
	
	private String getJumpAdvNo() throws Exception{		
		return ShortUrlCreater.createAdvNo();
	}
	
	/**
	 * 根据文件名获取版本号
	 * @return
	 */
	private String getVersion(){
		String apkName = apk.getChannelApkName();
		apkName = apkName.replace(".apk", "");		
		apkName = apkName.substring(apkName.indexOf("_")+1);
		if(apkName.indexOf("_")!=-1){
			apkName = apkName.split("_")[0];
		}
		return apkName;
	}

	
	private void updateDownLoad(CommonSpreadInfo spreadInfo){
		LinkInfo query = new LinkInfo();
		query.setLinklocid(APKLINKLOCID);
		query.setGameidbytuijian(gameId);
		LinkInfo info = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		if(info != null){
			info.setExt1(version);
			info.setExt2(apkSize+"M");
			info.setLinkurl(spreadInfo.getJumpUrl());
			info.setSmallpicurl(apk.getMuliPhotoUrl());
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(info);
		}
	}
	
	private void updateMobileIndexPage(){
		LinkInfo query = new LinkInfo();
		query.setLinklocid(APKLINKLOCID2);
		query.setGameidbytuijian(gameId);
		LinkInfo info = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		if(info != null){
			info.setExt2(apkSize);
			info.setLinkurl(apk.getDownLoadLink());
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(info);
		}
	}
	/**
	 * 更新下载地址
	 * @param version apk版本
	 */
	private void updateDownLink(CommonSpreadInfo spreadInfo){
		updateDownLoad(spreadInfo);		
		updateMobileIndexPage();		
	}
	
	
	/**
	 *  生成官网模版
	 */
	private void addTemplate(){
		for(int i=1;i<=3;i++)
			addDownLoad(i);
	}
	
	
	private void addDownLoad(int type){
		 String nowStr = com.xunlei.niux.manager.web.util.DateUtil.formatNowByDefault();
         //添加执行计划
         TemplateSchema ts=new TemplateSchema();
         if(type == 1){
        	 ts.setTemplateid(DOWNLOADLOCID);
         }else if(type==2){
        	 ts.setTemplateid(DOWNLOADLOCID2);
         }else{
        	 ts.setTemplateid(DOWNLOADLOCID3);
         }
         ts.setSchematime(nowStr);
         ts.setIsexecuted(false);
         ts.setInputby("系统");
         ts.setInputtime(nowStr);
         ts.setIspreview(false);            
         FacadeFactory.INSTANCE.getBaseSo().addObject(ts);
	}
}
