package com.xunlei.niux.manager.web.model.mobileapk.auditthread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ApkPackageThreadPool {

	  private static final ApkPackageThreadPool instance = new ApkPackageThreadPool();
	  private ExecutorService executor;
	  private ApkPackageThreadPool(){
		  init();
	  }
	
	  public static ApkPackageThreadPool getInstance(){
		  return instance;
	  }
      
	  private void init(){
		  executor  = Executors.newSingleThreadExecutor();
		  
		  Runtime.getRuntime().addShutdownHook(new Thread(){
			   public void run(){
				   shutDown();
			   }
		  });
	  }

	  private void shutDown(){
		  executor.shutdown();
	  }
	  
	  public void submit(Runnable task){
		  executor.submit(task);
	  }
}
