package com.xunlei.niux.manager.web.model.mobileapk.auditthread;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.client.mail.MailSendClient;
import com.xunlei.niux.data.auditplatform.enums.AuditStatus;
import com.xunlei.niux.data.auditplatform.facade.FacadeFactory;
import com.xunlei.niux.data.auditplatform.vo.AuditMobileGameInfo;
import com.xunlei.niux.data.auditplatform.vo.BusinessInfo;
import com.xunlei.niux.data.auditplatform.vo.UserInfo;
import com.xunlei.niux.data.vipgame.vo.GameXmlMeta;
import com.xunlei.niux.data.vipgame.vo.Games;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * Created by jamesjxin on 14-7-28.
 */
public class AfterAuditSendEmailThread implements Runnable{
    private static final Logger logger = Logger.getLogger(AfterAuditSendEmailThread.class.getName());
    private AuditMobileGameInfo auditInfo;
    private Games game;
    private GameXmlMeta gameXmlMeta;

    public AfterAuditSendEmailThread(AuditMobileGameInfo auditInfo, Games game, GameXmlMeta gameXmlMeta) {
        this.auditInfo = auditInfo;
        this.game = game;
        this.gameXmlMeta = gameXmlMeta;
    }

    @Override
    public void run() {
        if(auditInfo == null){
            logger.error("审核信息auditInfo为空！");
            return;
        }

        try {
            UserInfo userInfo = getUserInfoByUserId(auditInfo.getUserId());
            if(userInfo == null){
                logger.error("用户还未绑定邮箱！");
                return;
            }

            BusinessInfo businessInfo = getBusinessInfo();

            String title = "《"+auditInfo.getGameFullName()+"》审核通知";

            MailSendClient mailSendClient = getMailClient();

            if(auditInfo.getAuditStatus() == AuditStatus.AUDITFALSE.getValue()){
                logger.info(userInfo.getUserId()+"用户审核不通过，发送邮件给:"+userInfo.getEmail());
                mailSendClient.sendMail(title,getFailedEmailContent(businessInfo),userInfo.getEmail());
            }else if(auditInfo.getAuditStatus() == AuditStatus.AUDITSUCCESS.getValue()){
                logger.info(userInfo.getUserId()+"用户审核通过，发送邮件给:"+userInfo.getEmail());
                mailSendClient.sendMail(title,getSuccessEmailContent(businessInfo),userInfo.getEmail());
            }
        } catch (Exception e) {
            logger.error("发送审核邮件失败",e);
        }

    }

    private UserInfo getUserInfoByUserId(long userId){
        UserInfo query = new UserInfo();
        query.setUserId(userId);
        return FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    }

    private BusinessInfo getBusinessInfo(){
        BusinessInfo businessInfo = null;
        String cacheKey = "auditBusinessInfo";
        CacheManager cacheManager = CacheManager.GetInstance();
        Object object = cacheManager.get(cacheKey);
        if(object == null){
            Page page = new Page();
            page.addOrder("inputTime", OrderType.DESC);
            page.setPageNo(1);
            page.setPageSize(1);
            List<BusinessInfo> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(new BusinessInfo(),page);
            if(CollectionUtils.isNotEmpty(list)){
                businessInfo = list.get(0);
            }

            if(businessInfo != null){
                cacheManager.put(cacheKey,businessInfo,30);
            }
        }else{
            businessInfo = (BusinessInfo)object;
        }

        return businessInfo;

    }

    private String getSuccessEmailContent(BusinessInfo businessInfo){
        String businessStr = businessInfo.getBusinessFamilyName()+(businessInfo.getBusinessSex()?"小姐":"先生");

        String result = "<b>《"+auditInfo.getGameFullName()+"》的开发者您好：</b><br>" +
                "<br>" +
                "您向迅雷申请的产品联运已经通过初审，请安排及时对接我们的SDK，并与我们的商务（"+businessStr+" QQ："+businessInfo.getBusiness_QQ()+"）取得联系。<br>" +
                "<br>" +
                "SDK相关信息如下<br>" +
                "SDK下载地址(内含：SDK包，SDK接入说明文档，角标文件，闪屏文件，SDK-DEMO)：<br>" +
                businessInfo.getSdkDownloadUrl()+"<br>" +
                "<br><br>" +
                "您所申请的游戏参数：<br>" +
                "gameId:"+gameXmlMeta.getNewgameid()+"<br>" +
                "gameName:"+auditInfo.getGameFullName()+"<br>" +
                "appKey:"+gameXmlMeta.getLoginKey()+"<br>" +
                "exchangeRate:"+auditInfo.getCurrencyExchangeRate()+"<br>" +
                "exchangeUnit:"+auditInfo.getCurrencyName()+"<br>" +
                "channelId:xunlei<br><br>" +
                "SDK接入流程详见SDK包中的接入文档说明<br>";


        return result;
    }

    private String getFailedEmailContent(BusinessInfo businessInfo){
        String businessStr = businessInfo.getBusinessFamilyName()+(businessInfo.getBusinessSex()?"小姐":"先生");
        String result = "<b>《"+auditInfo.getGameFullName()+"》的开发者您好：</b><br>" +
                "<br>" +
                "非常抱歉的通知您，您向迅雷申请的产品联运未通过初审，详情请联系商务"+businessStr+"咨询（QQ："+businessInfo.getBusiness_QQ()+"）<br>";
        return result;
    }

    private MailSendClient getMailClient(){
        String host = "mail.xunlei.com";
        String fromName = "xlniux@xunlei.com";
        String fromPwd = "13eh6a1m";
        return new MailSendClient(host,fromName,fromPwd);
    }
}
