package com.xunlei.niux.manager.web.model.mobileapk;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;

import javax.faces.model.SelectItem;
import javax.imageio.ImageIO;


import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameXmlMeta;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.MobileChannel;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.MobileGameApk;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.MobileGameChannelApk;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.model.mobileapk.auditthread.ApkPackageThreadPool;
import com.xunlei.niux.manager.web.model.mobileapk.auditthread.ApkTask;
import com.xunlei.niux.manager.web.model.mobileapk.auditthread.ApkThreadPool;
import com.xunlei.niux.manager.web.util.PageUtil;
import com.xunlei.util.StringTools;


public class MobileApkManagedBean  extends BaseManagedBean  {
	private static final String apktester = EnvPropertyUtil.loadProperty("niux","apktester");
	private static final String packageChannelApk = "packchannelapk.sh";
	private static final String apkPath = "/usr/local/templatedata/apk/";
	private static final String downloadurl = "http://preloaddown.boxsvr.niu.xunlei.com/webgame/";
	private static final String SYNCPICCOMMOND = "rsync_apk.sh";
	private static  String qcodePath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("qcodePath");	//二维码图片远程存放路径
	private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");//二维码图片本地存放路径
	private static final String SYNCPICCOMMONDPHOTO = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("syncPicCommond");
	private static final int WIDTH_SMALL = 95;
	private static final int WIDTH_BIG = 300;
	
	//产品
    private static Map<String,String> channelMap;   
    private static  Map<String,String> channelAllMap;   
    private static Map<Long,String> apkMap; 
    private static List<SelectItem> channelList;
    private static List<SelectItem> apkList;

	public String make(){
    	MobileGameApk query = new MobileGameApk();
    	Page page = new Page();
    	List<MobileGameApk>  mgalist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
    	
    	MobileGameChannelApk channelquery = new MobileGameChannelApk();
    	List<MobileGameChannelApk>  mgcalist = FacadeFactory.INSTANCE.getBaseSo().findObjects(channelquery, page);
    	for(MobileGameApk apk:mgalist){
    		  	for(MobileGameChannelApk channel:mgcalist){   	   
	    	    	  if(channel.getApkId().longValue()==apk.getApkId().longValue()){
	    	    		  makeMultiFile(apk.getGameId(),channel.getDownLoadLink(),channel.getChannelApkName(),WIDTH_SMALL);
	    	    		  makeMultiFile(apk.getGameId(),channel.getDownLoadLink(),changeName(channel.getChannelApkName()),WIDTH_BIG);
	    	    		  channel.setMuliPhotoUrl(qcodePath+apk.getGameId()+"/"+(channel.getChannelApkName().replace(".apk", ".jpg")));
	    	    		  FacadeFactory.INSTANCE.getBaseSo().updateObjectById(channel);
	    	    	 }
    	      }    		
    	}
    	for(MobileGameApk apk:mgalist){	   	    	
	    		  makeMultiFile(apk.getGameId(),apk.getPath(),apk.getApkName(),WIDTH_SMALL);
	    		  makeMultiFile(apk.getGameId(),apk.getPath(),changeName(apk.getApkName()),WIDTH_BIG);
	    		  apk.setMuliPhotoUrl(qcodePath+apk.getGameId()+"/"+(apk.getApkName().replace(".apk", ".jpg")));
	    		  FacadeFactory.INSTANCE.getBaseSo().updateObjectById(apk);
        }    		  
    	return "";
    }
    
    private String changeName(String fileName){
    	if(fileName.indexOf(".apk")!=-1){
    		fileName = fileName.replace(".apk", "");
    	}
    	fileName += "_b";
    	return fileName+".apk";
    }
    
    private void makeMultiFile(String gameId,String apkUrl,String fileName,int awidth){
		try {            
			String codes [] = qcodePath.split("/");
			String apkcode = codes[codes.length-1];
			String path = FILEPATH+apkcode+"/"+gameId;
			 File file = new File(path);
			 if(!file.exists()){
				 file.mkdirs();
			 }
		     String content = apkUrl;		     
		     MultiFormatWriter multiFormatWriter = new MultiFormatWriter();		     
		     Map<EncodeHintType,Object> hints = new HashMap<EncodeHintType,Object>();
		     hints.put(EncodeHintType.MARGIN, 0); 
		     hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
		     BitMatrix bitMatrix = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, awidth, awidth,hints);
		     File file1 = new File(path,fileName.replace(".apk", ".jpg"));
		     MatrixToImageConfig config = new MatrixToImageConfig(0xFF000001, 0xFFFFFFFF);
		     MatrixToImageWriter.writeToFile(bitMatrix, "jpg", file1,config);
		   //1.1去白边
		     int[] rec = bitMatrix.getEnclosingRectangle();  
		     int resWidth = rec[2] + 1;  
		     int resHeight = rec[3] + 1;  
		     BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);  
		     resMatrix.clear();  
		     for (int i = 0; i < resWidth; i++) {  
		         for (int j = 0; j < resHeight; j++) {  
		             if (bitMatrix.get(i + rec[0], j + rec[1])) { 
		                  resMatrix.set(i, j); 
		             } 
		         }  
		     }  
		     int width = resMatrix.getWidth();
		     int height = resMatrix.getHeight();
		     int onColor = config.getPixelOnColor();
             int offColor = config.getPixelOffColor();
		     BufferedImage image = new BufferedImage(width, height,onColor != -16777216 || offColor != -1 ? 1 : 12);	       
		     for (int x = 0; x < width; x++) {
		         for (int y = 0; y < height; y++) {
		             image.setRGB(x, y, resMatrix.get(x, y) == true ? 
		             Color.BLACK.getRGB():Color.WHITE.getRGB());		    
		             image.setRGB(x, y, resMatrix.get(x, y) ? onColor : offColor);
		         }
		     }
		     ImageIO.write(image,"jpg", file1);		     
		     synchPhoto();
		 } catch (Exception e) {
		     e.printStackTrace();
		 }
	}
    
    public MobileApkManagedBean(){

    }
    
    private String getLoginKey(String gameid){
    	GameXmlMeta query = new GameXmlMeta();
    	query.setNewgameid(gameid);
    	GameXmlMeta meta = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    	if(meta == null)return null;
    	return meta.getLoginKey();
    }
    
	public String addChannel(){
		try{
			this.authenticateAdd();
			MobileChannel channel=this.findBean(MobileChannel.class, "mobileChannel");
			channel.setIsDel(false);
			FacadeFactory.INSTANCE.getBaseSo().addObject(channel);
			initChannelMap();
			initChannelList();
		}catch(Exception e){
			logger.error(e);
		}
		return "";
	}
	
	/**
	 * 同步apk
	 * @throws Exception
	 */
	public void synch() {
		try {
			 logger.info("开始同步apk,地址:/usr/local/bin/"+SYNCPICCOMMOND);
			 Runtime.getRuntime().exec("/usr/local/bin/"+SYNCPICCOMMOND);	
			 logger.info("apk同步成功！");
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
	}
	
	public void synchPhoto() {
		try {
			 logger.info("开始同步二维码图片,地址:/usr/local/bin/"+SYNCPICCOMMONDPHOTO);
			 Runtime.getRuntime().exec("/usr/local/bin/"+SYNCPICCOMMONDPHOTO);	
			 logger.info("apk同步成功！");
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
	}
	
	private String getDownLoadUrl(String gameNo,String fileName){
		return downloadurl+gameNo+"/"+fileName;
	}
	
	public String getQueryChannelList(){
		this.authenticateRun();
		MobileChannel channel=this.findBean(MobileChannel.class, "mobileChannel");
		channel.setIsDel(false);
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(channel);
		Page page=PageUtil.formatPage(this.getFliper());
		List<MobileChannel> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(channel, page);
		this.mergePagedDataModel(count, list);
		return "";
	}
	
	
	/**
	 * 手游包提测
	 * @return
	 */
	public String addMobileGameApk(){
		try{
			MobileGameApk apk=this.findBean(MobileGameApk.class, "mobileGameApk");
			apk.setApkStatus("0");
			String gameid = apk.getGameId();
			Games games = GameCache.getInstance().getGameByGameId(gameid);			
			String gameNo = games.getGameNo();
			String apkName = apk.getApkName();
			String apkurl = apk.getApkUrl();
			if(!apkName.startsWith(gameNo+"_")){//apk名称如果不是以游戏编号为前缀
				deleteFile(apkurl);//删除没用的文件
				alertJS("apk名称必须以 游戏编号_ 为前缀，如：bwzq_abc.apk");
				return "";
			}
			String fileName = apkurl.substring(apkurl.lastIndexOf("/")+1);
			if(!apkName.equals(fileName)){
				deleteFile(apkurl);//删除没用的文件
				alertJS("录入的apk名称与实际的不一致");
				return "";
			}
			MobileGameApk query = new MobileGameApk();
			query.setApkName(apk.getApkName());
			MobileGameApk myapk = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
			if(myapk != null){
				deleteFile(apkurl);//删除没用的文件
				alertJS("该apk名称已经存在，请不要重复添加");
				return "";
			}
						
			String pathName = null;
			if(apk.getPackageType().intValue()==1){
				fileName = fileName.replace(".apk", "");
				 pathName = fileName+"_"+"00000000.apk";
			}else{
				pathName = fileName;
			}

			apk.setPath(downloadurl+games.getGameNo()+"/"+pathName);
			
			if(apk.getPackageType().intValue()==1){
				String loginKey = getLoginKey(gameid);
				if(StringTools.isEmpty(loginKey)){
					alertJS("请先配置登录密钥");
					return "";
				}
				//打包
				packageApk(games.getGameNo(),fileName,"00000000",loginKey,apk.getApkId());
			}
									
			//生成二维码图片
			makeMultiFile(apk.getGameId(),apk.getPath(),pathName,WIDTH_SMALL);
			makeMultiFile(apk.getGameId(),apk.getPath(),changeName(pathName),WIDTH_BIG);
			apk.setMuliPhotoUrl(qcodePath+gameid+"/"+(pathName.replace(".apk", ".jpg")));
			apk.setPackageTime(sdf_time.format(new Date()));	
			
			FacadeFactory.INSTANCE.getBaseSo().addObject(apk);
			
			initApkMap();
			initApkList();
		}catch(Exception e){
			logger.error(e);
		}
		return "";
	}
	
	public static void deleteFile(String path){
		File file = new File(path);
		if(file.exists()){
			file.delete();
		}
	}
	
	public static void renameFile(String path,String oldname,String newname){ 
        if(!oldname.equals(newname)){//新的文件名和以前文件名不同时,才有必要进行重命名 
            File oldfile=new File(path+"/"+oldname); 
            File newfile=new File(path+"/"+newname); 
            if(!oldfile.exists()){
                return;//重命名文件不存在
            }
            if(newfile.exists())//若在该目录下已经有一个文件和新文件名相同，则不允许重命名 
                System.out.println(newname+"已经存在！"); 
            else{ 
                oldfile.renameTo(newfile); 
            } 
        }else{
            System.out.println("新文件名和旧文件名相同...");
        }
    }
	
	/**
	 * 测试人修改状态
	 * @return
	 */
	public String updateMobileGameApk(){
		try{
			MobileGameApk apk=this.findBean(MobileGameApk.class, "mobileGameApk");
			String gameid = apk.getGameId();
			Games games = GameCache.getInstance().getGameByGameId(gameid);			
			String gameNo = games.getGameNo();
			String apkName = apk.getApkName();
			if(!apkName.startsWith(gameNo+"_")){//apk名称如果不是以游戏编号为前缀
				alertJS("apk名称必须以 游戏编号_ 为前缀，如：bwzq_abc.apk");
				return "";
			}

			if("2".equals(apk.getApkStatus())||"3".equals(apk.getApkStatus())){//测试失败或者测试成功
				UserInfo userInfo = currentUserInfo();
				apk.setTestUser(userInfo.getUserlogno());
				apk.setTestTime(now());
			}			
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(apk);
			
		}catch(Exception e){
			logger.error(e);
		}
		return "";
	}
	
	private String getApkSize(MobileGameChannelApk apk){
		String channelApkName = apk.getChannelApkName();
		String refferName = channelApkName.substring(0,channelApkName.indexOf("_"));
		channelApkName = apkPath +refferName+"/"+channelApkName;
		File file = new File(channelApkName);
		if(!file.exists()){
			throw new XLRuntimeException("该apk在服务器目录中不存在");
		}
		FileInputStream fis = null;
		int size = 0;
		try{
			fis = new FileInputStream(file);
			size = fis.available()/1000000;
		}catch(Exception e){
			throw new XLRuntimeException("apk文件读取失败");
		}finally{
			if(fis != null){
				try {
					fis.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return size+"";
	}
	
	private void updateNewDataToOffical(MobileGameChannelApk apk,String gameId,String apkSize){	
			ApkTask task = new ApkTask(apk,gameId,apkSize);
			ApkThreadPool.getInstance().execute(task);
	}
	
	/**
	 * 
	 * @param gameNo
	 * @param apkName
	 * @param channelId
	 * @param loginKey
	 * @param apkId 渠道APKid,为的是渠道包打完之后跟新状态为“待测试”
	 */
	public void packageApk(final String gameNo,final String apkName,final String channelId,final String loginKey,final long apkId){
		
		ApkPackageThreadPool.getInstance().submit(new Runnable(){

			@Override
			public void run() {
				Process p = null;
				 try {
					 logger.info("packageApk  gameNo:"+gameNo+",apkName:"+apkName+",channelId:"+channelId+",loginKey:"+loginKey+",apkId:"+apkId+"     start.........");
					 p = Runtime.getRuntime().exec(apkPath+packageChannelApk+" "+gameNo+" "+apkName+" "+channelId+" "+loginKey);
					 final InputStream eis = p.getErrorStream();
					 final InputStream iis = p.getInputStream();
					 
					 new Thread() {  
						    public void run(){
						       BufferedReader ebr = new BufferedReader(new InputStreamReader(eis));  
						        try {  
						            String error = null;  
						            while ((error = ebr.readLine()) != null) {  
						                  if (error != null){
						                	  logger.info("error:"+error);
						                  }  
						              }  
						        } catch (IOException e) {  
						             e.printStackTrace();  
						        }  
						        finally{  
						             try{
						            	 if(eis != null)
						            		 eis.close();  
						             } catch (IOException e) {  
						                e.printStackTrace();  
						            }  
						          }  
						        }  
						     }.start();  
						                                
					   new Thread(){
					      public void  run(){
					       BufferedReader ibr = new  BufferedReader(new  InputStreamReader(iis));   
					          try {   
					             String input = null ;   
					             while ((input = ibr.readLine()) !=  null ) {   
					                  if (input != null){
					                	  logger.info("input:"+input);
						              }  
					             }   
					           } catch (IOException e) {   
					                 e.printStackTrace();  
					           }   
					          finally{  
					             try {
					            	 if(iis != null)
					            		 iis.close();  
					             } catch (IOException e) {  
					                 e.printStackTrace();  
					             }  
					           }  
					        }   
					      }.start();   
						
					 int result = p.waitFor();
					 p.destroy();
					 
					 Thread.sleep(1000);//等待渠道APK信息入库
					 
					 //更新渠道APK信息 to testing
					 if(result == 0 && !"00000000".equals(channelId)){
						 logger.info("packageApk update status  channelId:"+channelId+",apkId:"+apkId+"   begin query.");
						 MobileGameChannelApk apk = new MobileGameChannelApk();
						 apk.setChannelId(channelId);
						 apk.setApkId(apkId);
						 apk = FacadeFactory.INSTANCE.getBaseSo().findObject(apk);
						 if(apk != null){//打完包之后，全部改为待测
							 logger.info("packageApk update status  channelId:"+channelId+",apkId:"+apkId+"   begin update.");
							 apk.setChannleApkStatus("0");//待测
							 FacadeFactory.INSTANCE.getBaseSo().updateObjectById(apk);
						 }
					 }
					 
					 logger.info("packageApk  gameNo:"+gameNo+",apkName:"+apkName+",channelId:"+channelId+",loginKey:"+loginKey+",apkId:"+apkId+",result:"+result+"   end.");
				} catch (Exception e) {			
					logger.error("[packageApk] ERROR:",e);
				}finally{
					if(p != null) p.destroy();
				}
			}});
		
	}
	
	public String getQueryMobileGameApkList(){
		MobileGameApk apk=this.findBean(MobileGameApk.class, "mobileGameApk");
		if(apk != null){
			if(apk.getApkId()!=null&&apk.getApkId().longValue()==0){
				apk.setApkId(null);
			}
			if(apk.getApkStatus()!=null&&"-1".equals(apk.getApkStatus())){
				apk.setApkStatus(null);
			}
		}
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(apk);
		Page page=PageUtil.formatPage(this.getFliper());
		page.addOrder("packageTime", OrderType.DESC);
		List<MobileGameApk> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(apk, page);
		this.mergePagedDataModel(count, list);
		return "";
	}
	
 	
	
	public String addMobileGameChannelApk(){		
		try{
			MobileGameChannelApk apk=this.findBean(MobileGameChannelApk.class, "mobileGameChannelApk");
			apk.setChannleApkStatus("4");
			apk.setPackageTime(sdf_time.format(new Date()));				
			MobileGameApk query = new MobileGameApk();
			query.setApkId(apk.getApkId());
			MobileGameApk mga = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
			if(mga == null){
				alertJS("基本apk不存在");
				return "";
			}			
			
			int packageType = mga.getPackageType().intValue();
			if(packageType == 0){//如果不需要重新打包，则不能打渠道包
				alertJS("该基础包不需要重新打包");
				return "";
			}
			String channelId = apk.getChannelId();
			MobileGameChannelApk mgcaquery = new MobileGameChannelApk();
			mgcaquery.setChannelId(apk.getChannelId());
			mgcaquery.setApkId(apk.getApkId());
			MobileGameChannelApk mgca = FacadeFactory.INSTANCE.getBaseSo().findObject(mgcaquery);
			if(mgca != null){
				alertJS("该渠道的该APK已经存在");
				return "";
			}
			String gameid = mga.getGameId();
			String loginKey = getLoginKey(gameid);
			if(StringTools.isEmpty(loginKey)){
				alertJS("请先配置登录密钥");
				return "";
			}
			Games games = GameCache.getInstance().getGameByGameId(gameid);	
			String gameNo = games.getGameNo();		
			
			System.out.println("apkchannel gameno:"+gameNo);
			System.out.println("channelId:"+channelId);
			String apkName = apkMap.get(apk.getApkId());
			apkName = apkName.replace(".apk", "");
			
			String channleApkName = getChannelApkName(apkName,apk.getChannelId());
			apk.setDownLoadLink(getDownLoadUrl(gameNo,channleApkName));//生成的渠道包下载链接			
			apk.setChannelApkName(apkName+"_"+apk.getChannelId()+".apk");//生成的渠道包名
			
			System.out.println("apkchannel apkName:"+apk.getChannelApkName());
			
			//生成二维码图片
			makeMultiFile(gameid,apk.getDownLoadLink(),channleApkName,WIDTH_SMALL);
			makeMultiFile(gameid,apk.getDownLoadLink(),changeName(channleApkName),WIDTH_BIG);
			//打包
			packageApk(gameNo,apkName,apk.getChannelId(),loginKey, apk.getApkId());							
			apk.setMuliPhotoUrl(qcodePath+gameid+"/"+(channleApkName.replace(".apk", ".jpg")));		
			apk.setPackageTime(sdf_time.format(new Date()));	
			
			FacadeFactory.INSTANCE.getBaseSo().addObject(apk);
		}catch(Exception e){
			logger.error(e);
		}
		return "";
	}
	
	private String getChannelApkName(String fileName,String channelId){
		if(fileName.indexOf(".apk")==-1){
			return fileName+"_"+channelId+".apk";
		}else{
			String subName = fileName.substring(0,fileName.lastIndexOf(".apk"));
			return subName +"_"+channelId+".apk";
		}
	}
	
	public static void fileChannelCopy(File s, File t) {
		FileInputStream fi = null;
		FileOutputStream fo = null;
		FileChannel in = null;
		FileChannel out = null;
		try {
			fi = new FileInputStream(s);
			fo = new FileOutputStream(t);
			in = fi.getChannel();// 得到对应的文件通道
			out = fo.getChannel();// 得到对应的文件通道
			in.transferTo(0, in.size(), out);// 连接两个通道，并且从in通道读取，然后写入out通道
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				fi.close();
				in.close();
				fo.close();
				out.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	public Map<String, String> getChannelAllMap(){
		if(channelAllMap == null){
			initChannelMap();
		}		
		return channelAllMap;
	}
	
	
	public Map<String, String> getChannelMap(){
		if(channelMap == null){
			initChannelMap();
		}		
		return channelMap;
	}
	
	public Map<String, String> initChannelMap() {
		Map<String,String> tempAllMap=new HashMap<String,String>();
        Map<String,String> tempMap=new HashMap<String,String>();
        MobileChannel query=new MobileChannel();
		List<MobileChannel> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
        if(bplist!=null){
        	for(MobileChannel product:bplist){
        		tempAllMap.put(product.getChannelId()+"", product.getChannelName()); 	
        		if(!product.getIsDel()){//如果没有删除
        			tempMap.put(product.getChannelId()+"", product.getChannelName()); 	
        		}
			}
        }
        channelAllMap=tempAllMap;
        channelMap=tempMap;
		return channelAllMap;
	}
	
	public Map<Long, String> getApkMap() {
		if(apkMap == null){
			initApkMap();
		}
		return apkMap;
	}
	
	public Map<Long, String> initApkMap() {
        Map<Long,String> tempMap=new HashMap<Long,String>();
        MobileGameApk query=new MobileGameApk();
        Page page = new Page();
		page.addOrder("gameId", OrderType.ESC);
		page.addOrder("packageTime", OrderType.ESC);
		List<MobileGameApk> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);
        if(bplist!=null){
        	for(MobileGameApk product:bplist){
        		tempMap.put(product.getApkId(), product.getApkName()); 	
			}
        }
        apkMap=tempMap;
		return apkMap;
	}
	
	public List<SelectItem> getChannelList(){
		if(channelList == null){
			initChannelList();
		}
		return channelList;
	}
	
	public List<SelectItem> initChannelList(){
		MobileChannel query=new MobileChannel();
		query.setIsDel(false);
		List<MobileChannel> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
		List<SelectItem> siList=new ArrayList<SelectItem>();
		if(bplist==null){
			return siList;
		}
		for(MobileChannel product:bplist){
			siList.add(new SelectItem(product.getChannelId()+"", product.getChannelName())); 	
		}
		channelList = siList;
		return siList;
	}
	
	public List<SelectItem> getApkList(){
		if(apkList == null){
			initApkList();
		}
		return apkList;
	}
	
	public List<SelectItem> initApkList(){
		MobileGameApk query=new MobileGameApk();
		Page page = new Page();
		page.addOrder("gameId", OrderType.ESC);
		page.addOrder("packageTime", OrderType.ESC);
		List<MobileGameApk> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);
		List<SelectItem> siList=new ArrayList<SelectItem>();
		if(bplist==null){
			return siList;
		}
		for(MobileGameApk product:bplist){
			siList.add(new SelectItem(product.getApkId()+"", product.getApkName())); 	
		}
		apkList = siList;
		return siList;
	}
	
	private String getGameId(MobileGameChannelApk apk){
		MobileGameApk query = new MobileGameApk();
		query.setApkId(apk.getApkId());
		MobileGameApk mga = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		if(mga == null){
			throw new XLRuntimeException("该渠道包的基础包已不存在");
		}
		return mga.getGameId();
	}
	
	public String updateMobileGameChannelApk(){
		try{
			MobileGameChannelApk apk=this.findBean(MobileGameChannelApk.class, "mobileGameChannelApk");
			if("2".equals(apk.getChannleApkStatus())||"3".equals(apk.getChannleApkStatus())){//测试失败或者测试成功

				MobileGameChannelApk apk_db = new MobileGameChannelApk();
				apk_db.setChannelApkId(apk.getChannelApkId());
				apk_db = FacadeFactory.INSTANCE.getBaseSo().findObject(apk_db);
				if(apk_db != null && "4".equals(apk_db.getChannleApkStatus())){//打包中
					apk.setChannleApkStatus(apk_db.getChannleApkStatus());
					alertJS("该apk正在打包，请等待打包完成后再进行测试。");
					return "";
				}
				
				UserInfo userInfo = currentUserInfo();
				apk.setTestUser(userInfo.getUserlogno());
				apk.setTestTime(now());
			}
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(apk);
			if("3".equals(apk.getChannleApkStatus())){//如果测试通过
				String apkSize = getApkSize(apk);
				System.out.println("apkSize:"+apkSize);
				String gameId =getGameId(apk);
				System.out.println("gameId:"+gameId);
				updateNewDataToOffical(apk,gameId,apkSize);
			}
			
		}catch(Exception e){
			logger.error(e);
			alertJS(e.getMessage());
		}
		return "";
	}
	
	
	public String getQueryMobileGameChannelApkList(){
		MobileGameChannelApk apk=this.findBean(MobileGameChannelApk.class, "mobileGameChannelApk");
		if(apk != null){
			if(apk.getApkId() != null&&apk.getApkId().longValue()==0){
				apk.setApkId(null);
			}
			if(apk.getChannleApkStatus()!=null&&"-1".equals(apk.getChannleApkStatus())){
				apk.setChannleApkStatus(null);
			}
		}
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(apk);
		Page page=PageUtil.formatPage(this.getFliper());
		page.addOrder("packageTime", OrderType.DESC);
		List<MobileGameChannelApk> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(apk, page);
		this.mergePagedDataModel(count, list);
		return "";
	}
	
	
	/**
	 * 删除基础包信息
	 * @return
	 */
	public String delete(){
		logger.info("开始基础包信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
				FacadeFactory.INSTANCE.getBaseSo().deleteById(MobileGameApk.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除渠道包信息
	 * @return
	 */
	public String deleteChannel(){
		logger.info("开始渠道包信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
				FacadeFactory.INSTANCE.getBaseSo().deleteById(MobileGameChannelApk.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	public String updateChannel(){
		logger.info("开始渠道包信息逻辑删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");	
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids){
				MobileChannel channel =  FacadeFactory.INSTANCE.getBaseSo().findById(MobileChannel.class, id);
				channel.setIsDel(true);
				FacadeFactory.INSTANCE.getBaseSo().updateObjectById(channel);
			}
		}catch(Exception e){
			logger.error("逻辑删除失败", e);
			mergeJsmessage("逻辑删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}

