package com.xunlei.niux.manager.web.model.mobileapk;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.auditplatform.bo.BaseSo;
import com.xunlei.niux.data.auditplatform.enums.AuditStatus;
import com.xunlei.niux.data.auditplatform.facade.FacadeFactory;
import com.xunlei.niux.data.auditplatform.vo.AuditMobileGameInfo;
import com.xunlei.niux.data.vipgame.vo.GameXmlMeta;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.niux.easyutils.commonutils.ParamUtil;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.model.mobileapk.auditthread.AddGameDatabaseAndLoginConfigThread;
import com.xunlei.niux.manager.web.model.mobileapk.auditthread.AddGameServerThread;
import com.xunlei.niux.manager.web.model.mobileapk.auditthread.AfterAuditSendEmailThread;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;

import java.util.*;
import java.util.concurrent.*;

/**
 * Created by jamesjxin on 14-7-24.
 */
@FunRef("auditmobilegame")
public class AuditMobileGameManagedBean extends BaseManagedBean {

    private static final Logger logger = Logger.getLogger(AuditMobileGameManagedBean.class.getName());

    private BaseSo baseSo;
    private int rownum = 0;


    public AuditMobileGameManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        //初始化行号
        int pageNo = this.getFliper().getPageNo();
        int pageSize = this.getFliper().getPageSize();
        rownum = rownum + (pageNo - 1) * pageSize + 1;
    }


    public int getRownum() {
        return rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }


    /**
     * 查询抽奖奖品
     *
     * @return
     */
    public String getQueryUnAuditGameList() {
        System.out.print("getQueryUnAuditGameList");
        this.authenticateRun();//验证运行权限
        AuditMobileGameInfo auditInfo = findBean(AuditMobileGameInfo.class, "auditmobilegameinfo");
        String email = findParameter("email");

        if(auditInfo == null){
            auditInfo = new AuditMobileGameInfo();
        }
        if(auditInfo.getUserId()!=null && auditInfo.getUserId()==0L){
            auditInfo.setUserId(null);
        }

        if(auditInfo.getAuditStatus()!=null && auditInfo.getAuditStatus()==0){
            auditInfo.setAuditStatus(null);
        }

        if(StringUtils.isNotEmpty(email)){
            auditInfo.setUserEmail(email);
        }

        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(auditInfo);;

        pagedFliper.setRecordCount(count);
        List<AuditMobileGameInfo> list = new ArrayList<AuditMobileGameInfo>();
        if (count > 0) {
            rownum = 1;
            Page page = new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("recordTime", OrderType.DESC);
            list = baseSo.findObjects(auditInfo, page);
        }
        Sheet<AuditMobileGameInfo> sheet = new Sheet<AuditMobileGameInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    /**
     * 审核游戏信息
     *
     * @return
     */
    public String auditTrue() {
        logger.info("开始抽奖奖品信息修改");
        this.authenticateEdit();//编辑权限

        /**
         1.新增游戏信息 （优先有要游戏信息）
         2.新增默认区服信息
         3.新增数据库
         4.新增登录配置信息并同步出去
         5.更新审核状态
         */

        AuditMobileGameInfo auditInfo = findBean(AuditMobileGameInfo.class, "auditmobilegameinfo");
        if(auditInfo == null){
            throw new XLRuntimeException("审核信息为空！");
        }

        if(auditInfo.getAuditStatus() == AuditStatus.AUDITSUCCESS.getValue()){
            throw new XLRuntimeException("已经审核过！");
        }

        doAuditMobileGame(auditInfo,true);

        return "";
    }

    public String auditFalse() {
        logger.info("开始抽奖奖品信息修改");
        this.authenticateEdit();//编辑权限

        /**
         1.新增游戏信息 （优先有要游戏信息）
         2.新增默认区服信息
         3.新增数据库
         4.新增登录配置信息并同步出去
         5.更新审核状态
         */

        AuditMobileGameInfo auditInfo = findBean(AuditMobileGameInfo.class, "auditmobilegameinfo");
        if(auditInfo == null){
            throw new XLRuntimeException("审核信息为空！");
        }

        if(auditInfo.getAuditStatus() == AuditStatus.AUDITFALSE.getValue()){
            throw new XLRuntimeException("已经审核过！");
        }

        doAuditMobileGame(auditInfo,false);

        return "";
    }

    private void doAuditMobileGame(AuditMobileGameInfo auditInfo,boolean auditFlag){
        if(!auditFlag){
            updateAuditStatus(auditInfo, auditFlag);
            new AfterAuditSendEmailThread(auditInfo,null,null).run();
            return;
        }

        if(ParamUtil.isParamsEmpty(auditInfo.getGameFullName(), auditInfo.getGameNamePinYin(), auditInfo.getCurrencyName())){
            throw new XLRuntimeException("游戏名称，拼音，游戏币名称等信息不能为空！");
        }

        if(auditInfo.getCurrencyExchangeRate()==null || auditInfo.getCurrencyExchangeRate()<=0){
            throw new XLRuntimeException("游戏币汇率不能小于0！");
        }

        UserInfo userInfo = currentUserInfo();
        Games game = AddGameByAudit(auditInfo,userInfo);

        if(game == null){
            throw new XLRuntimeException("审核的游戏信息添加失败！");
        }

        ExecutorService executorService = Executors.newCachedThreadPool();

        Future<Map<String,Object>> futureTask1 = executorService.submit(new AddGameServerThread(game,userInfo));
        Future<Map<String,Object>> futureTask2 = executorService.submit(new AddGameDatabaseAndLoginConfigThread(game));

        GameXmlMeta gameXmlMeta = null;
        try {
            int code;
            Map<String,Object> addGameServerResult = futureTask1.get();
            code = Integer.parseInt(addGameServerResult.get("code").toString());
            if(code != 0){
                String msg = addGameServerResult.get("data").toString();
                throw new XLRuntimeException(msg);
            }

            Map<String,Object> addGameLoginConfigResult = futureTask2.get();
            code = Integer.parseInt(addGameLoginConfigResult.get("code").toString());
            if(code != 0){
                String msg = addGameLoginConfigResult.get("data").toString();
                throw new XLRuntimeException(msg);
            }
            gameXmlMeta = (GameXmlMeta)addGameLoginConfigResult.get("data");
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (ExecutionException e) {
            e.printStackTrace();
        }

        if(gameXmlMeta == null){
            throw new XLRuntimeException("添加游戏配置信息失败！");
        }

        updateAuditStatus(auditInfo,auditFlag);

        executorService.submit(new AfterAuditSendEmailThread(auditInfo,game,gameXmlMeta));
        executorService.shutdown();
        while (!executorService.isShutdown()){}
        return;
    }

    private void updateAuditStatus(AuditMobileGameInfo auditInfo, boolean auditFlag){
        if(auditFlag){
            auditInfo.setAuditStatus(AuditStatus.AUDITSUCCESS.getValue());
        }else {
            auditInfo.setAuditStatus(AuditStatus.AUDITFALSE.getValue());
        }
        auditInfo.setAuditTime(DateUtil.formatNowByDefault());
        FacadeFactory.INSTANCE.getBaseSo().updateObjectById(auditInfo);
    }

    private Games AddGameByAudit(AuditMobileGameInfo auditInfo,UserInfo userInfo){
        //判断游戏信息是否存在
        Games game = GameCache.getInstance().getGameByGameNo(auditInfo.getGameNamePinYin());

        if(game != null){
            throw new XLRuntimeException("游戏拼音缩写已经存在！");
        }

        if(auditInfo.getGameNamePinYin().length()>10){
            throw new XLRuntimeException("游戏拼音缩写不能超过10个字符！");
        }

        game = new Games();

        String defaulURL = "http://";
        game.setGameId(getMobileGameNewGameId());
        game.setGameNo(auditInfo.getGameNamePinYin());
        game.setGameName(auditInfo.getGameFullName());
        game.setGameType("1");//游戏类型，默认1
        game.setClientType(3);//手游
        game.setLoadClientType(3);//手机
        game.setGameFeature(10);//游戏特征：其他
        game.setPlayLevel(1);//上手度：易
        game.setStatus("1");//游戏状态：已接入
        game.setHasBigFenQu(false);
        game.setIsNew(false);
        game.setIsHot(false);
        game.setGameDesc(auditInfo.getGameIntroduction());
        game.setOfficialWebSite(defaulURL);
        game.setPayUrl(defaulURL);
        game.setForumUrl(defaulURL);
        game.setCoparnterId("1");//合作方Id，默认1
        game.setDisplayOrder(1L);
        game.setSimpleName(auditInfo.getGameNamePinYin());
        game.setMobileGameType(1);//默认网络游戏
        game.setRecommendIndex("9");
        game.setSmallPicUrl(defaulURL);
        game.setPicUrl(defaulURL);

        game.setRunStatus("01");
        game.setUseTemplate(true);

        game.setInputBy(userInfo.getTrueName());
        game.setInputTime(DateUtil.formatNowByDefault());

        com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getGamesBo().insertGames(game);
        //更新缓存
        GameCache.getInstance().updateCache();
        addGameTemplateSchema();

        return game;
    }

    private synchronized String getMobileGameNewGameId(){
        String gameIdStr = "050001";//默认
        Games newestGame = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getGamesBo().getCurrentNewstMobileGame();
        if(newestGame == null){
           return gameIdStr;
        }

        int gameId = Integer.parseInt(newestGame.getGameId())+1;
        gameIdStr = String.valueOf(gameId);
        int length = gameIdStr.length();
        for(int i=0;i<6-length;i++){
            gameIdStr = "0"+gameIdStr;
        }

        return gameIdStr;
    }

    private void addGameTemplateSchema(){
        String nowStr=DateUtil.formatNowByDefault();
        //添加执行计划
        TemplateSchema ts=new TemplateSchema();
        ts.setTemplateid("000007");
        ts.setSchematime(nowStr);
        ts.setIsexecuted(false);
        ts.setInputby("系统");
        ts.setInputtime(nowStr);
        ts.setIspreview(false);
        ts.setExt1("");
        com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
    }
}
