package com.xunlei.niux.manager.web.model.lychat;

import com.mysql.jdbc.exceptions.jdbc4.MySQLIntegrityConstraintViolationException;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.lychat.facade.FacadeFactory;
import com.xunlei.niux.data.lychat.vo.*;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.cache.LyChatCache;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.model.BlackWhiteInfoManagedBean;
import com.xunlei.niux.manager.web.model.vo.BlackWhiteInfo;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.RBundleUtil;
import com.xunlei.niux.manager.web.vo.JsonRecord;
import com.xunlei.niux.manager.web.vo.Record;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONArray;
import org.json.JSONObject;

import javax.faces.model.SelectItem;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class LyChatMonitorManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(LyChatMonitorManagedBean.class.getName());
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String xlniuxlychatsvr =  EnvPropertyUtil.loadProperty("niux", "xlniuxlychatsvr");
    private static final String xlniuxlychatrecordsvr =  EnvPropertyUtil.loadProperty("niux", "xlniuxlychatrecordsvr");
    private static String customerInterface= IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("customerInterface");
    private int rownum = 0;
    private String newopenserver;
    private List<String> customerIdByIpList = new ArrayList<String>();
    private List<SelectItem> lychatGame;

    public String getNewopenserver() {
        return newopenserver;
    }

    public void setNewopenserver(String newopenserver) {
        this.newopenserver = newopenserver;
    }

    public LyChatMonitorManagedBean() {
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }


    public String queryChatDetailList(){
        try{
    		this.authenticateRun();
            LyChatDetailVO lcd = findBean(LyChatDetailVO.class, "lychatdetail");
            LyChatPageVO page = findBean(LyChatPageVO.class, "lychatpage");
            Integer lpn = findParamInt("lychat_query_lastPageNum");
            Long ttt = findParamLong("lychat_query_timestamp");
            page.setLastPageNum(lpn);
            page.setTimestamp(ttt);
            Map logBean = BeanUtils.describe(lcd);

            if(StringUtils.isEmpty(lcd.getGameId())){
                throw new XLRuntimeException("请选择游戏！");
            }
            if(lcd.getServerId()==null){
                throw new XLRuntimeException("请输入区服ID！");
            }

            PagedFliper pagedFliper = this.getFliper();
            logger.info("queryChatDetailList START:" + logBean + "," + BeanUtils.describe(page));

            StringBuilder urlSb = new StringBuilder();
            urlSb.append(xlniuxlychatrecordsvr);
            if(StringUtils.isEmpty(lcd.getRoleName())){
                long qto = System.currentTimeMillis();
                long qfrom = qto-600000;
                urlSb.append("/chat/queryChatInfoByTimestamp?")
                        .append("gameId=").append(lcd.getGameId())
                        .append("&serverId=").append(lcd.getServerId())
                        .append("&pageNum=").append(page.getPageNo())
                        .append("&pageSize=").append(page.getPageSize())
                        .append("&to=").append(qto)
                        .append("&from=").append(qfrom);
            }else {
                urlSb.append("/chat/queryChatInfoByRoleName?")
                        .append("gameId=").append(lcd.getGameId())
                        .append("&serverId=").append(lcd.getServerId())
                        .append("&pageNum=").append(page.getPageNo())
                        .append("&pageSize=").append(page.getPageSize())
                        .append("&roleName=").append(lcd.getRoleName());
            }

            if(page.getPageNo()>1){
                urlSb
                    .append("&timestamp=").append(page.getTimestamp())
                    .append("&lastPageNum=").append(page.getLastPageNum());
            }
            logger.info("queryChatDetailList send:" + urlSb.toString());
            String resp = HttpClientUtil.get(urlSb.toString());
            logger.info("查询返回："+resp);
//            String resp = testmsg;
            JSONObject respJson = new JSONObject(resp);
            Integer status = respJson.getInt("rtn");
            if(status!=0){
                logger.error("queryChatDetailList 拉取数据失败:" + logBean + ", 返回:" + resp);
                mergeJsmessage("获取聊天记录失败，原因：" + resp);
                return "";
            }

            JSONObject data = respJson.getJSONObject("data");
            JSONArray entity = data.getJSONArray("entity");

            List<LyChatDetailVO> crList = getDataList(entity);
            if(crList.size()>0){
                LyChatPageVO lyChatPageVO = new LyChatPageVO();
                lyChatPageVO.setTimestamp(data.getLong("timestamp"));
                lyChatPageVO.setLastPageNum(data.getInt("pageNum"));

                if(data.has("isEndPage")){
                    lyChatPageVO.setIsEndPage(data.getString("isEndPage"));
                }

                mergeBean(lyChatPageVO, "lychatpage");
            }
            Sheet<LyChatDetailVO> sheet=new Sheet<LyChatDetailVO>(crList.size(),crList);
            this.mergePagedDataModel(sheet, pagedFliper);
            return "";

        }catch(Exception e){
            logger.error("获取聊天记录失败", e);
            mergeJsmessage("获取聊天记录失败，原因：" + e.getMessage());
        }
        return "";

    }

    private List<LyChatDetailVO> getDataList(JSONArray jsonArray) throws Exception{
        List<LyChatDetailVO> cdList = new ArrayList<LyChatDetailVO>();
        for(int i=0;i<jsonArray.length();i++){
            JSONObject json = (JSONObject)jsonArray.get(i);
            LyChatDetailVO cd = new LyChatDetailVO();
            cd.setGameId(json.getString("gameId"));
            cd.setServerId(Integer.valueOf(json.getString("serverId")));
            cd.setCustomerId(json.getString("customerId"));
            cd.setRoleId(json.getString("roleId"));
            cd.setRoleLevel(Integer.valueOf(json.getString("roleLevel")));
            cd.setRoleName(json.getString("roleName"));
            cd.setChatIp(json.getString("chatIp"));
            cd.setChatTime(sdf.format(json.getLong("chatTime")));
            cd.setChatChannel(json.getString("chatChannel"));
            cd.setChatContent(json.getString("chatContent"));
            cd.setChatContentStyle(json.getString("chatContent_color"));
            cdList.add(cd);
        }
        return cdList;
    }

    private String highLight(String content){
        String sensitive = LyChatCache.getInstance().getSensitiveWithSplit();
        Pattern pattern = Pattern.compile(sensitive);
        Matcher mc = pattern.matcher(content);
        StringBuffer sb=new StringBuffer();
        while (mc.find()) {
            String keyword =mc.group();
            mc.appendReplacement(sb, "<span class=\"lychatsensitive\">" + keyword + "</span>");
        }
        mc.appendTail(sb);
        return sb.toString();
    }

    public String getTodayAndYesterdayServer(){
        try{
            String gameId = findParameter("lychatdetail_gameId");

            if(StringUtils.isEmpty(gameId)){
                mergeJsmessage("游戏获取异常！");
                setNewopenserver("");
                return "";
            }
            List<String> params = new ArrayList<String>();
            params.add(gameId);
            String sql = "select * from gameservers where gameid=? and openstatus=1 and ( to_days(opentime) = to_days(now()) or to_days(opentime)+1 = to_days(now()) ) order by opentime desc";
            List<GameServers> lastServerList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().executeQuery(GameServers.class, sql, params);
            if(lastServerList==null||lastServerList.isEmpty()){
                mergeJsmessage("游戏没有开服！");
                setNewopenserver("");
                return "";
            }
            StringBuilder ls = new StringBuilder();
            for(GameServers gs : lastServerList){
                ls.append(gs.getFenQuNum()).append(",");
            }
            String s = ls.toString();
            setNewopenserver(s.substring(0, s.length()-1));
        }catch(Exception e){
            logger.error("获取最新区服失败", e);
            setNewopenserver("");
            mergeJsmessage("获取最新区服失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String punishRoleName(){
        this.authenticateRun();
        try{
            final LyChatDetailVO lcd = findBean(LyChatDetailVO.class, "lychatdetail");
            String opId = findParameter("lychatdetail_operationId");

            if(StringUtils.isEmpty(lcd.getGameId())){
                throw new XLRuntimeException("请选择游戏！");
            }
            if(lcd.getServerId()==null){
                throw new XLRuntimeException("请输入区服ID！");
            }
            if(StringUtils.isEmpty(lcd.getRoleName())){
                throw new XLRuntimeException("请输入角色名！");
            }

            LyChatOperationVO qlco = new LyChatOperationVO();
            qlco.setOpId(opId);
            if(FacadeFactory.INSTANCE.getBaseSo().countObject(qlco)==0){
                throw new XLRuntimeException("未找到操作IDlychat_operationId="+opId);
            }
            
            Map logBean = BeanUtils.describe(lcd);
            logger.info("punishRoleName START:"+logBean);

            //send req
            StringBuilder urlSb = new StringBuilder();
            urlSb.append(xlniuxlychatsvr).append("/lychat/punish.do?")
                    .append("action=").append(opId)
                    .append("&gameid=").append(lcd.getGameId())
                    .append("&serverid=").append(lcd.getServerId())
                    .append("&rolename=").append(URLEncoder.encode(lcd.getRoleName(),"utf8"));
            logger.info("punishRoleName send:"+urlSb.toString());
            String resp = HttpClientUtil.get(urlSb.toString());

            int isSuccess;
            String errorMsg;
            long detailId = -1;
            if("0".equals(resp)){
                isSuccess=1;
                errorMsg="";
                //更新处理详情
                lcd.setWarnType(0);
                detailId = FacadeFactory.INSTANCE.getBaseSo().insertReturnId(lcd);
                FacadeFactory.INSTANCE.getBaseSo().addObject(lcd);
            }else {
                errorMsg = "操作失败: " + resp;
                logger.error("操作失败:"+"resp:"+resp+"," + logBean);
                mergeJsmessage(errorMsg);
                return "";
            }

            //操作日志
            LyChatOperationLogVO lco = new LyChatOperationLogVO();
            lco.setDetailId(detailId);
            lco.setOpId(opId);
            lco.setDescription("");
            lco.setOperator(this.currentUserLogo());
            lco.setWorkTime(DateUtil.formatNowByDefault());
            lco.setIsSuccess(isSuccess);
            lco.setErrorMsg(errorMsg);
            FacadeFactory.INSTANCE.getBaseSo().addObject(lco);
            logger.info("punishRoleName SUCCESS:"+logBean);
            return "";

        }catch(Exception e){
            logger.error("punishRoleName 操作失败", e);
            mergeJsmessage("操作失败，原因：" + e.getMessage());
        }
        return "";

    }

    public String punishCustomerId(){
        this.authenticateRun();
        try{
            final LyChatDetailVO lcd = findBean(LyChatDetailVO.class, "lychatdetail");
            String opId = findParameter("lychatdetail_operationId");

            if(StringUtils.isEmpty(lcd.getGameId())){
                throw new XLRuntimeException("请选择游戏！");
            }
            if(lcd.getServerId()==null){
                throw new XLRuntimeException("请输入区服ID！");
            }
            if(StringUtils.isEmpty(lcd.getCustomerId())){
                throw new XLRuntimeException("请输入账号！");
            }

            LyChatOperationVO qlco = new LyChatOperationVO();
            qlco.setOpId(opId);
            if(FacadeFactory.INSTANCE.getBaseSo().countObject(qlco)==0){
                throw new XLRuntimeException("未找到lychat_operationId="+opId);
            }

            Map logBean = BeanUtils.describe(lcd);
            logger.info("punishCustomerId START:"+logBean);
            
            //send req
            StringBuilder urlSb = new StringBuilder();
            urlSb.append(xlniuxlychatsvr).append("/lychat/punish.do?")
                    .append("action=").append(opId)
                    .append("&gameid=").append(lcd.getGameId())
                    .append("&serverid=").append(lcd.getServerId())
                    .append("&customerid=").append(lcd.getCustomerId());
            logger.info("punishCustomerId send:"+urlSb.toString());
            String resp = HttpClientUtil.get(urlSb.toString());

            int isSuccess;
            String errorMsg;
            long detailId=-1;
            if("0".equals(resp)){
                isSuccess=1;
                errorMsg="";
                //更新处理详情
                lcd.setWarnType(0);
                detailId = FacadeFactory.INSTANCE.getBaseSo().insertReturnId(lcd);
            }else {
                errorMsg = "操作失败: " + resp;
                logger.error("操作失败:"+"resp:"+resp+"," + logBean);
                mergeJsmessage(errorMsg);
                return "";
            }
            
            //操作日志
            LyChatOperationLogVO lco = new LyChatOperationLogVO();
            lco.setDetailId(detailId);
            lco.setOpId(opId);
            lco.setDescription("");
            lco.setOperator(this.currentUserLogo());
            lco.setWorkTime(DateUtil.formatNowByDefault());
            lco.setIsSuccess(isSuccess);
            lco.setErrorMsg(errorMsg);
            FacadeFactory.INSTANCE.getBaseSo().addObject(lco);
            logger.info("punishRoleName SUCCESS:"+logBean);
            return "";

        }catch(Exception e){
            logger.error("LyChatMonitorManagedBean punish 操作失败", e);
            mergeJsmessage("操作失败，原因：" + e.getMessage());
        }
        return "";

    }
    
    public String punishIp(){
    	this.authenticateRun();
        try{
            final LyChatDetailVO lcd = findBean(LyChatDetailVO.class, "lychatdetail");
            
            String punishIpType = findParameter("lychatdetail_punishIpType");
            if(StringUtils.isEmpty(lcd.getGameId())){
                throw new XLRuntimeException("请选择游戏！");
            }
            if(StringUtils.isEmpty(lcd.getChatIp())){
                throw new XLRuntimeException("请输入ip！");
            }

            //在我方平台进行封禁
            if(punishIpType.equals("0")){
            	//封禁
            	punishInBlackList(lcd.getGameId(), lcd.getChatIp(), "2", "2");
            }else if(punishIpType.equals("1")){
				dePunishInBlackList(lcd.getGameId(), lcd.getChatIp(), "2", "2");
			}
            else {
            	throw new XLRuntimeException("punishIpType有误"+punishIpType);
			}
        }catch (MySQLIntegrityConstraintViolationException e) {
        	logger.error("LyChatMonitorManagedBean punish 操作失败", e);
            mergeJsmessage("操作失败，原因：" + "该IP已被封禁，请先解禁");
		}catch(Exception e){
            logger.error("LyChatMonitorManagedBean punish 操作失败", e);
            mergeJsmessage("操作失败，原因：" + e.getMessage());
        }
        return "";
    }
    
    public String punishCustomerIdAllServer(){
    	this.authenticateRun();
        try{
            final LyChatDetailVO lcd = findBean(LyChatDetailVO.class, "lychatdetail");
            
            String punishCustomerAllServerType = findParameter("lychatdetail_punishCustomerAllServerType");
            if(StringUtils.isEmpty(lcd.getGameId())){
                throw new XLRuntimeException("请选择游戏！");
            }
            if(StringUtils.isEmpty(lcd.getCustomerId())){
                throw new XLRuntimeException("请输入账号！");
            }

            //在我方平台进行封禁
            if(punishCustomerAllServerType.equals("0")){
            	//封禁
            	punishInBlackList(lcd.getGameId(), lcd.getCustomerId(), "0", "1");
            }else if(punishCustomerAllServerType.equals("1")){
				dePunishInBlackList(lcd.getGameId(), lcd.getCustomerId(), "0", "1");
			}
            else {
            	throw new XLRuntimeException("punishCustomerAllServerType有误"+punishCustomerAllServerType);
			}
        }catch (MySQLIntegrityConstraintViolationException e) {
        	logger.error("LyChatMonitorManagedBean punish 操作失败", e);
            mergeJsmessage("操作失败，原因：" + "该账号已被封禁，请先解禁");
		}catch(Exception e){
            logger.error("LyChatMonitorManagedBean punish 操作失败", e);
            mergeJsmessage("操作失败，原因：" + e.getMessage());
        }
        return "";
    }

    public List<String> getCustomerIdByIpList() {
        return customerIdByIpList;
    }

    public List<String> getCustomerIdByIp() {
        customerIdByIpList.clear();
        try {
            LyChatDetailVO lcd = findBean(LyChatDetailVO.class, "lychatdetail");
            Map logBean = BeanUtils.describe(lcd);

            if(StringUtils.isEmpty(lcd.getGameId())){
                throw new XLRuntimeException("请选择游戏！");
            }
            if(lcd.getServerId()==null){
                throw new XLRuntimeException("请输入区服ID！");
            }

            if (StringUtils.isEmpty(lcd.getChatIp())) {
                mergeJsmessage("IP为空！");
                return null;
            }

            logger.info("getCustomerIdByIpList START:" + lcd.getChatIp());


            StringBuilder urlSb = new StringBuilder();
            urlSb.append(xlniuxlychatrecordsvr).append("/chat/queryChatInfoByIp?")
                    .append("gameId=").append(lcd.getGameId())
                    .append("&serverId=").append(lcd.getServerId())
                    .append("&ip=").append(lcd.getChatIp());
            logger.info("getCustomerIdByIpList send:" + urlSb.toString());
            String resp = HttpClientUtil.get(urlSb.toString());
            logger.info("getCustomerIdByIpList resp:" + resp);
            JSONObject respJson = new JSONObject(resp);
            Integer status = respJson.getInt("rtn");
            if (status != 0) {
                logger.error("getCustomerIdByIpList 拉取数据失败:" + lcd.getChatIp() + ", 返回:" + resp);
                mergeJsmessage("获取失败，原因：" + respJson.getString("msg"));
                return null;
            }

            JSONObject data = respJson.getJSONObject("data");
            JSONArray entity = data.getJSONArray("entity");
            for(int i=0;i<entity.length();i++){
                JSONObject json = (JSONObject)entity.get(i);
                customerIdByIpList.add(json.getString("customerId"));
            }

            if(customerIdByIpList.isEmpty()){
                throw new XLRuntimeException("找不到对应账号！");
            }

            //get uid
            Map<String,String> cusUidMap = getCustomeIdToUserIdMap(lcd.getGameId());

            //highlight customer if paid
            for(int i=0;i<customerIdByIpList.size();i++){
                String cusId = customerIdByIpList.get(i);
                String uid = cusUidMap.get(cusId);
                if(hasPaid(uid)){
                    customerIdByIpList.set(i,"<span class=\"lychatsensitive\">" + cusId + "</span>"+":"+uid);
                }else {
                    customerIdByIpList.set(i,cusId+":"+uid);
                }
            }


            return customerIdByIpList;
        }catch(Exception e){
            logger.error("获取数据失败", e);
            mergeJsmessage("获取数据失败，原因：" + e.getMessage());
        }
        return null;
    }

    private Map<String,String> getCustomeIdToUserIdMap(String gameId) throws Exception{

        Map<String,String> cusUidMap = new HashMap<String, String>();
        if(customerIdByIpList.isEmpty())return cusUidMap;
        StringBuilder accSb = new StringBuilder();
        for(String acc:customerIdByIpList){
            accSb.append(acc).append(",");
        }
        String acc = accSb.toString();
        acc = acc.substring(0,acc.length()-1);
        String url = "http://websvr.niu.xunlei.com/queryUserInfo.gameUserInfo?gameid="+gameId+"&type=200&accounts="+acc;
        logger.info("getCustomerIdByIpList查找uid"+url);
        String rr = HttpClientUtil.get(url);
        logger.info("getCustomerIdByIpList查找uid返回"+rr);
        JSONObject uidJson = new JSONObject(rr);
        String statues = uidJson.getString("statues");
        if(!"0".equals(statues)){
            throw new XLRuntimeException("查找UID失败");
        }
        String result = uidJson.getString("result");
        String[] cusToUidArr = result.split("&");
        for(String cuArr:cusToUidArr){
            String[] cr = cuArr.split("=");
            if(cr[1]!=null && !"".equals(cr[1]) && !"null".equalsIgnoreCase(cr[1])) {
                cusUidMap.put(cr[0],null);
            }
            cusUidMap.put(cr[0],cr[1]);
        }
        return cusUidMap;
    }

    private boolean hasPaid(String uid) throws Exception {
        if(StringUtils.isEmpty(uid))return false;

        String jsonStr = HttpClientUtil.getInfoForHttpGetMothed(customerInterface+"uid="+uid+"&date="+DateUtil.formatNow("yyyy-MM-dd"));
        if(StringUtils.isEmpty(jsonStr)){
            throw new XLRuntimeException("查找充值数据失败");
        }

        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonRecord record = mapper.readValue(jsonStr, JsonRecord.class);
            List<Record> recordList = record.getList();
            if(recordList == null||recordList.size()==0){
                throw new XLRuntimeException("查找充值数据失败");
            }
            String firstLoginTime = null;//游戏的首次登录时间
            String lastLoginTime = null;//游戏的最后登录时间
            String firstPayTime = null;//游戏的首次充值时间
            String lastPayTime = null;//游戏的最后充值时间
            double payTotal = 0L;//充值金额
            long payCount = 0L;//充值次数
            long gameCount = 0L;//激活游戏数
            long serverCount= 0L;//激活区服数
            long payGameCount = 0L;//充值游戏数
            long payServerCount = 0L;//充值区服数
            Set<String> game = new HashSet<String>();
            Set<String> pay = new HashSet<String>();
            for(int i=0;i<recordList.size();i++){
                Record rd = recordList.get(i);
                payTotal += rd.getPayAmt();
                payCount += rd.getPayTimes();
                if(firstLoginTime==null){
                    firstLoginTime = rd.getFirstLoginTime();
                }else{
                    firstLoginTime = rd.getFirstLoginTime()==null||"".equals(rd.getFirstLoginTime())?firstLoginTime:(firstLoginTime==null||"".equals(firstLoginTime)?rd.getFirstLoginTime():(compareTime(firstLoginTime,rd.getFirstLoginTime())>0?rd.getFirstLoginTime():firstLoginTime));
                }
                if(lastLoginTime==null){
                    lastLoginTime = rd.getFirstLoginTime();
                }else{
                    lastLoginTime = rd.getLastLoginTime()==null||"".equals(rd.getLastLoginTime())?lastLoginTime:(lastLoginTime==null||"".equals(lastLoginTime)?rd.getLastLoginTime():(compareTime(lastLoginTime,rd.getLastLoginTime())<0?rd.getLastLoginTime():lastLoginTime));
                }
                if(firstPayTime==null){
                    firstPayTime = rd.getFirstPayTime();
                }else{
                    firstPayTime = rd.getFirstPayTime()==null||"".equals(rd.getFirstPayTime())?firstPayTime:(firstPayTime==null||"".equals(firstPayTime)?rd.getFirstPayTime():(compareTime(firstPayTime,rd.getFirstPayTime())>0?rd.getFirstPayTime():firstPayTime));
                }
                if(lastPayTime==null){
                    lastPayTime = rd.getLastPayTime();
                }else{
                    lastPayTime = rd.getLastPayTime()==null||"".equals(rd.getLastPayTime())?lastPayTime:(lastPayTime==null||"".equals(lastPayTime)?rd.getLastPayTime():(compareTime(lastPayTime,rd.getLastPayTime())<0?rd.getLastPayTime():lastPayTime));
                }

                if(rd.getFirstLoginTime() != null&& !"".equals(rd.getFirstLoginTime())){
                    serverCount++;
                    game.add(rd.getGameId());
                }
                if(rd.getFirstPayTime() != null && !"".equals(rd.getFirstPayTime())){
                    payServerCount ++;
                    pay.add(rd.getGameId());
                }
            }

            //最后充值时间是否在三个月以内
            if(StringUtils.isEmpty(lastPayTime)){
                return false;
            }
            Calendar startCalendar = Calendar.getInstance();
            startCalendar.setTime(new SimpleDateFormat("yyyy-MM-dd").parse(lastPayTime));
            Calendar endCalendar = Calendar.getInstance();
            endCalendar.setTime(new Date());
            int diffYear = endCalendar.get(Calendar.YEAR) - startCalendar.get(Calendar.YEAR);
            int diffMonth = diffYear * 12 + endCalendar.get(Calendar.MONTH) - startCalendar.get(Calendar.MONTH);
            return diffMonth<=3;
        } catch (JsonParseException e) {
            e.printStackTrace();
        } catch (JsonMappingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return false;
    }

    public void setCustomerIdByIpList(List<String> customerIdByIpList) {
        this.customerIdByIpList = customerIdByIpList;
    }

    public long compareTime(String fromtime,String totime){
        if(StringTools.isEmpty(totime))return 1000;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date one = null;
        Date two = null;
        long days=0;
        try{
            one = df.parse(fromtime);
            two = df.parse(totime);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 - time2;
            days = diff / (1000 * 60 * 60 * 24);
        }catch(ParseException e){
            e.printStackTrace();
        }
        return days;
    }

    public List<SelectItem> getLychatGame() {
        List<SelectItem> list = new ArrayList<SelectItem>();
        Set<String> gameIdSet = LyChatCache.getInstance().getLyChatGameMap().keySet();
        for(String gameId:gameIdSet){
            SelectItem si=new SelectItem();
            si.setLabel(GameCache.getInstance().getGameIdNameMap().get(gameId));
            si.setValue(gameId);
            list.add(si);
        }

        return lychatGame=list;
    }
    
    /**
     * 将信息添加到blackinfo表中，在登陆时，由我方进行封禁
     * @param gameId         游戏id
     * @param info           customerId或者ip			
     * @param infoType       0表示uid,2表示ip
     * @param punishType     1表示id，2表示ip
     * @throws Exception
     */
    private void punishInBlackList(String gameId, String info, String infoType, String punishType) throws Exception{
    	//添加到黑名单中
        BlackWhiteInfo blackInfo =  new BlackWhiteInfo();
        blackInfo.setEditor(this.currentUserLogo());
        blackInfo.setEdittime(Long.toString(System.currentTimeMillis()/1000L));
        blackInfo.setOverduedate("");	//永久
        blackInfo.setReason("聊天违禁");
        
        if("1".equals(punishType)){
        	//由于登陆逻辑中是按照uid进行拦截的，所以这里把加密账号转成uid，添加到数据库中
    		String uid = "";
    		uid = BlackWhiteInfoManagedBean.getQueryAccountChangeList(gameId, info).get(0);
    		if (uid == null || "null".equals(uid)) {
    			throw new Exception("加密账号不存在");
    		}
    		blackInfo.setLogininfo(uid);
    		blackInfo.setType("0");	//0表示uid，1表示加密账号，2表示ip
        }else {
        	blackInfo.setLogininfo(info);
    		blackInfo.setType("2");	//0表示uid，1表示加密账号，2表示ip
		}
		
        String dbName = BlackWhiteInfoManagedBean.getDBName(gameId);
        BlackWhiteInfoManagedBean.addBlackWhiteInfoForOneGame(blackInfo, gameId, dbName, 1);	//0表示白名单,1表示黑名单
    	
    }
    
    /**
     * 解封禁
     * @param gameId         游戏id
     * @param info           customerId或者ip			
     * @param infoType       0表示uid,2表示ip
     * @throws Exception     1表示id，2表示ip
     */
    private void dePunishInBlackList(String gameId, String info, String infoType, String punishType) throws Exception{
    	//添加到黑名单中
        BlackWhiteInfo blackInfo =  new BlackWhiteInfo();
        blackInfo.setEditor(this.currentUserLogo());
        blackInfo.setEdittime(Long.toString(System.currentTimeMillis()/1000L));
        blackInfo.setOverduedate(DateUtil.formatNowByDefault());	//将过期时间设置为当前时间
        blackInfo.setReason("聊天解封禁");
        
        if("1".equals(punishType)){
        	//由于登陆逻辑中是按照uid进行拦截的，所以这里把加密账号转成uid，添加到数据库中
        	String uid = "";
    		uid = BlackWhiteInfoManagedBean.getQueryAccountChangeList(gameId, info).get(0);
    		if (uid == null || "null".equals(uid)) {
    			throw new Exception("加密账号不存在");
    		}
    		blackInfo.setLogininfo(uid);
    		blackInfo.setType("0");	//0表示uid，1表示加密账号，2表示ip
        }else {
        	blackInfo.setLogininfo(info);
    		blackInfo.setType("2");	//0表示uid，1表示加密账号，2表示ip
		}
        
        String dbName = BlackWhiteInfoManagedBean.getDBName(gameId);
        BlackWhiteInfoManagedBean.deleteBlackWhiteInfoForOneGame(blackInfo, gameId, dbName, 1);	//0表示白名单,1表示黑名单
    	
    }


    static String testmsg = "{\"status\":0,\"data\":[{\"gameId\":\"000202\",\"serverId\":\"1\",\"customerId\":\"xldts001\",\"roleId\":\"123\",\"roleLevel\":\"1\",\"roleName\":\"heheda\",\"chatTime\":\"1432732175671\",\"chatIp\":\"192.168.1.1\",\"chatContent\":\"%e5%b8%a6%e4%bd%a0%e9%a3%9e\",\"chatChannel\":\"world\"},{\"gameId\":\"000202\",\"serverId\":\"1\",\"customerId\":\"xldts001\",\"roleId\":\"123\",\"roleLevel\":\"1\",\"roleName\":\"heheda\",\"chatTime\":\"1432732175671\",\"chatIp\":\"192.168.1.1\",\"chatContent\":\"%e6%88%91%e5%8e%bbfuck\",\"chatChannel\":\"world\"}],\"msg\":\"\"}";

}
