package com.xunlei.niux.manager.web.model.lychat;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.lychat.bo.BaseSo;
import com.xunlei.niux.data.lychat.facade.FacadeFactory;
import com.xunlei.niux.data.lychat.vo.LyChatGameVO;
import com.xunlei.niux.data.lychat.vo.LyChatSensitiveVO;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.niux.manager.web.cache.LyChatCache;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.RBundleUtil;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;


public class LyChatGameManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;
    private static final String xlniuxlychatsvr =  EnvPropertyUtil.loadProperty("niux", "xlniuxlychatsvr");

    public LyChatGameManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public String getLyChatGame(){
        this.authenticateRun();

        LyChatGameVO query = new LyChatGameVO();
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);

        List<LyChatGameVO> list = new ArrayList<LyChatGameVO>();
        if(count>0){
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            list = baseSo.findObjects(query, page);
        }
        Sheet<LyChatGameVO> sheet = new Sheet<LyChatGameVO>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add(){
        this.authenticateAdd();//新增权限
        try{
            LyChatGameVO lcg = findBean(LyChatGameVO.class,"lychatgame");
            if(StringUtils.isEmpty(lcg.getGameId())){
                throw new XLRuntimeException("游戏ID为空");
            }

            LyChatGameVO query = new LyChatGameVO();
            query.setGameId(lcg.getGameId());

            if(baseSo.countObject(query)>0){
                throw new XLRuntimeException("已经存在，请不要重复添加");
            }

            baseSo.addObject(lcg);
            updateLychatGameCache();

        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }
    public String edit(){
        this.authenticateEdit();
        try{
            LyChatGameVO lcg = findBean(LyChatGameVO.class,"lychatgame");
            if(StringUtils.isEmpty(lcg.getGameId())){
                throw new XLRuntimeException("游戏ID为空");
            }

            Long seqId = lcg.getSeqId();
            LyChatGameVO query = new LyChatGameVO();
            query.setSeqId(seqId);
            if(baseSo.countObject(query)==0){
                throw new XLRuntimeException(seqId+"不存在，修改失败！");
            }

            baseSo.updateObjectById(lcg);
            updateLychatGameCache();

        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                baseSo.deleteById(LyChatGameVO.class, id);
                updateLychatGameCache();
            }
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";

    }

    private void updateLychatGameCache(){
        LyChatCache.getInstance().updateLyChatGameCache();
        String url = xlniuxlychatsvr+"/lychat/updategame.do";
        logger.info("update remote chat game url:"+url);
        String resp = HttpClientUtil.get(url);
        logger.info("update remote chat game response:"+resp);
    }

}
