package com.xunlei.niux.manager.web.model.lottery;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;

import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.model.vo.UserDetail;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryRecord;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 抽奖记录查询业务处理类
 * @author lisu
 *  2013-04-19
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_LOTTERYRECORD)
public class LotteryRecordManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(LotteryRecordManagedBean.class.getName());
	private BaseSo baseSo;
	private int rownum = 0;
	

    private String advNo;
    private String giftIds;
    private String fromSuccessTime;
    private String toSuccessTime;

	
	public LotteryRecordManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	public String getAdvNo() {
		return advNo;
	}


	public void setAdvNo(String advNo) {
		this.advNo = advNo;
	}


	public String getGiftIds() {
		return giftIds;
	}


	public void setGiftIds(String giftIds) {
		this.giftIds = giftIds;
	}

	public String getFromSuccessTime() {
		return fromSuccessTime;
	}

	public void setFromSuccessTime(String fromSuccessTime) {
		this.fromSuccessTime = fromSuccessTime;
	}

	public String getToSuccessTime() {
		return toSuccessTime;
	}

	public void setToSuccessTime(String toSuccessTime) {
		this.toSuccessTime = toSuccessTime;
	}


	/**
	 * 查询抽奖记录
	 * @return
	 */
	public String getQueryLotteryRecordList(){
		logger.info("开始抽奖记录查询");
        this.authenticateRun();//验证运行权限
        LotteryRecord record = findBean(LotteryRecord.class, "lotteryrecord");
        String lotteryrecord_isProvided = findParameter("lotteryrecord_isProvided");
        if(lotteryrecord_isProvided ==null||"".equals(lotteryrecord_isProvided)){
        	record.setIsProvided(null);
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(record);
        pagedFliper.setRecordCount(count);
        List<LotteryRecord> list = new ArrayList<LotteryRecord>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("recordTime", OrderType.DESC);
            list = baseSo.findObjects(record, page);
        }
        Sheet<LotteryRecord> sheet = new Sheet<LotteryRecord>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
     * 将抽奖名单导出到excel中
     */
    public void export(){
    	logger.info("开始名单数据导出到excel文件");
		
    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date()); 
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = "抽奖名单明细";	 
 	    
 	    StringBuilder sb = new StringBuilder("SELECT lotteryrecord.userid,lotteryrecord.giftid,lotteryrecord.recordTime,gift.giftName, deliveryaddress.userName,deliveryaddress.userRealName,deliveryaddress.province,deliveryaddress.city, deliveryaddress.district,deliveryaddress.detailAddress,deliveryaddress.postCode,deliveryaddress.telephone,deliveryaddress.mobilePhone FROM lotteryrecord LEFT JOIN giftshopreleaserecord ON lotteryrecord.recordId = giftshopreleaserecord.`giftRecordId` LEFT JOIN gift ON lotteryrecord.giftId = gift.giftId  LEFT JOIN deliveryaddress ON lotteryrecord.userid = deliveryaddress.userid WHERE (giftshopreleaserecord.releaseStatus IS NULL OR giftshopreleaserecord.releaseStatus != 1)  AND deliveryaddress.addressid IS NOT NULL AND gift.giftId <> 1000");//  and  gift.giftType = 'product'  ");
 	    
 	    List<String> args = new ArrayList<String>();
 	    if(!StringUtils.isEmpty(advNo)){
 	    	sb.append("  and lotteryrecord.actNo = ? ");
 	    	args.add(advNo);
 	    }

 	    if(!StringUtils.isEmpty(fromSuccessTime)){
 	    	sb.append(" and lotteryrecord.recordTime >= ? ");
 	    	args.add(fromSuccessTime);
 	    }
 	    
 	    if(!StringUtils.isEmpty(toSuccessTime)){
 	    	sb.append(" and lotteryrecord.recordTime <= ? ");
 	    	args.add(toSuccessTime);
 	    }
 	    
 	    if(!StringUtils.isEmpty(giftIds)){
 	    	String[] giftids = giftIds.split(",");
 	    	if(giftids.length > 0){
 	    		sb.append(" and gift.giftId in (");
 	    		int i = 0;
 	    		for(String giftid : giftids){
 	    			
 	    			if(i != 0){
 	    				sb.append(",");
 	    			}

 	 	 	    	sb.append("?");
 	 	 	    	args.add(giftid);
 	    		}
 	    		sb.append(") ");

 	    	}
 	    	
 	    }
 	    
 	    List<UserDetail> listUserDetail = this.baseSo.executeQuery(UserDetail.class, sb.toString(), args);
 	   
 	    List datas = new ArrayList();
 	    for(UserDetail cr : listUserDetail){
 	    	List list = new ArrayList();
 	    	list.add(cr.getUserId());
 	    	list.add(cr.getGiftid());
 	    	list.add(cr.getGiftName());
 	    	list.add(cr.getRecordTime());
 	    	list.add(cr.getUserName());
 	    	list.add(cr.getUserRealName());
 	    	list.add(cr.getProvince());
 	    	list.add(cr.getCity());
 	    	list.add(cr.getDistrict()); 	    	
 	    	list.add(cr.getDetailAddress());
 	    	list.add(cr.getPostCode());
 	    	list.add(cr.getTelephone());
 	    	list.add(cr.getMobilePhone());
 	    	datas.add(list);
 	    }	    
 	    //生成数据到excel中
		String[] columnName = {"userid", "giftid", "giftName", "recordTime", "userName", "userRealName", "province", "city", "district", "detailAddress", "postCode", "telephone", "mobilePhone"};
		String filePath = "/tmp/lotteryUserDetails.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("抽奖名单明细", title, columnName, filePath, datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+"lotteryUserDetails.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			logger.error("抽奖名单导出异常", e);
		}finally{
			if(datas != null){
				datas.clear();
				datas = null;
			}
		}
		FacesContext.getCurrentInstance().responseComplete();	   
    }

}
