package com.xunlei.niux.manager.web.model.limit;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.pay.bo.MonthLimitGiftBo;
import com.xunlei.niux.data.pay.facade.FacadeFactory;
import com.xunlei.niux.data.pay.facade.IFacade;
import com.xunlei.niux.data.pay.vo.MonthLimitGift;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MonthLimitGiftManagedBean extends BaseManagedBean
{
    private static final Logger logger = Logger.getLogger(MonthLimitGiftManagedBean.class.getName());
    private int rownum = 0;

    public MonthLimitGiftManagedBean()
    {
        int pageNo = getFliper().getPageNo();
        int pageSize = getFliper().getPageSize();
        this.rownum = (this.rownum + (pageNo - 1) * pageSize + 1);
    }

    public int getRownum() {
        return this.rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    public String getQueryMonthLimitGiftList()
    {
        logger.info("开始每月限额查询");
        authenticateRun();
        MonthLimitGift query = (MonthLimitGift)findBean(MonthLimitGift.class, "monthlimitgift");
        PagedFliper pagedFliper = getFliper();
        int count = FacadeFactory.INSTANCE.getMonthLimitGiftBo().count(query);
        pagedFliper.setRecordCount(count);
        List list = new ArrayList();
        if (count > 0) {
            this.rownum = 1;
            Page page = new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("month", OrderType.DESC);
            list = FacadeFactory.INSTANCE.getMonthLimitGiftBo().findMonthLimitGift(query, page);
        }
        Sheet sheet = new Sheet(count, list);
        mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
        return "";
    }

    public String edit()
    {
        logger.info("开始每月限额信息修改");
        authenticateEdit();
        MonthLimitGift gift = (MonthLimitGift)findBean(MonthLimitGift.class, "monthlimitgift");
        try {
            if (gift == null) {
                logger.info("每月限额信息为空");
                throw new XLRuntimeException("每月限额信息为空");
            }
            gift.setEditTime(now());
            gift.setEditBy(currentUserLogo());
            FacadeFactory.INSTANCE.getMonthLimitGiftBo().update(gift);
        } catch (Exception e) {
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete()
    {
        logger.info("开始每月限额信息删除");
        authenticateDel();
        String delseqids = findParameter("delseqids");
        try {
            String[] ids = delseqids.split(",");
            for (String id : ids)
                FacadeFactory.INSTANCE.getMonthLimitGiftBo().delete(Long.valueOf(Long.parseLong(id)));
        } catch (Exception e) {
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";
    }
}