package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.TimeTask;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 金钻定时任务记录查询类
 * @author lisu
 * 2014-06-12
 */
public class TimeTaskManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(TimeTaskManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public TimeTaskManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询金钻定时任务记录
	 * @return
	 */
	public String getQueryTimeTaskList(){		
	    logger.info("开始金钻定时任务记录查询");
        this.authenticateRun();//验证运行权限
        TimeTask query = findBean(TimeTask.class, "jinzuan_time_task");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<TimeTask> list = new ArrayList<TimeTask>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("startTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<TimeTask> sheet = new Sheet<TimeTask>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
}
