package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.PrivilegeReceiveInfo;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 用户特权处理类
 * @author lisu
 * 2014-04-03
 */
public class PrivilegeReceiveInfoManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(PrivilegeReceiveInfoManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public PrivilegeReceiveInfoManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询用户特权
	 * @return
	 */
	public String getQueryPrivilegeReceiveInfoList(){		
	    logger.info("开始用户特权查询");
        this.authenticateRun();//验证运行权限
        PrivilegeReceiveInfo query = findBean(PrivilegeReceiveInfo.class, "jinzuan_privilegereceiveinfo");
        PagedFliper pagedFliper = this.getFliper();    
        if(query != null){
        	if(query.getUserId() != null&&query.getUserId()==0){
        		query.setUserId(null);
        	}
        }
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<PrivilegeReceiveInfo> list = new ArrayList<PrivilegeReceiveInfo>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("recordTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<PrivilegeReceiveInfo> sheet = new Sheet<PrivilegeReceiveInfo>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	

}
