package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.PrivilegeReceiveHistory;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 特权使用情况处理类
 * @author lisu
 * 2014-04-03
 */
public class PrivilegeReceiveHistoryManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(PrivilegeReceiveHistoryManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public PrivilegeReceiveHistoryManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询特权使用情况
	 * @return
	 */
	public String getQueryPrivilegeReceiveHistoryList(){		
	    logger.info("开始特权使用情况查询");
        this.authenticateRun();//验证运行权限
        PrivilegeReceiveHistory query = findBean(PrivilegeReceiveHistory.class, "jinzuan_privilegereceivehistory");
        PagedFliper pagedFliper = this.getFliper();    
        if(query != null){
        	if(query.getUserId() != null&&query.getUserId().longValue()==0){
        		query.setUserId(null);
        	}
        	if(query.getPrivilegeType() != null&&query.getPrivilegeType().intValue()==0){
        		query.setPrivilegeType(null);
        	}
        }
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<PrivilegeReceiveHistory> list = new ArrayList<PrivilegeReceiveHistory>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("recordTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<PrivilegeReceiveHistory> sheet = new Sheet<PrivilegeReceiveHistory>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	

}
