package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.PrivilegeFailureUser;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 特权使用失败的用户信息处理类
 * @author lisu
 * 2014-04-03
 */
public class PrivilegeFailureUserManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(PrivilegeFailureUserManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public PrivilegeFailureUserManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询特权使用失败的用户信息
	 * @return
	 */
	public String getQueryPrivilegeFailureUserList(){		
	    logger.info("开始特权使用失败的用户信息查询");
        this.authenticateRun();//验证运行权限
        PrivilegeFailureUser query = findBean(PrivilegeFailureUser.class, "jinzuan_privilegefailureuser");
        PagedFliper pagedFliper = this.getFliper();    
        if(query != null){
        	if(query.getUserId() != null&&query.getUserId()==0){
        		query.setUserId(null);
        	}
        	if(query.getPrivilegeType()!=null&&query.getPrivilegeType().intValue()==0){
        		query.setPrivilegeType(null);
        	}
        	System.out.println(query.getErrorRtn());
        }
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<PrivilegeFailureUser> list = new ArrayList<PrivilegeFailureUser>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("daytime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<PrivilegeFailureUser> sheet = new Sheet<PrivilegeFailureUser>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	

}
