package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.Level;
import com.xunlei.niux.data.jinzuan.vo.PrivateKey;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 金钻体系密钥处理类
 * @author lisu
 * 2014-04-03
 */
public class PrivateKeyManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(PrivateKeyManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public PrivateKeyManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询金钻体系密钥
	 * @return
	 */
	public String getQueryPrivateKeyList(){		
	    logger.info("开始金钻体系密钥查询");
        this.authenticateRun();//验证运行权限
        PrivateKey query = findBean(PrivateKey.class, "jinzuan_privatekey");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<PrivateKey> list = new ArrayList<PrivateKey>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<PrivateKey> sheet = new Sheet<PrivateKey>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增金钻体系密钥
	 * @return
	 */
	public String add(){
		logger.info("开始金钻体系密钥信息添加");
		this.authenticateAdd();//添加权限
		PrivateKey key = findBean(PrivateKey.class, "jinzuan_privatekey");
		try{
			if(key==null){
				logger.info("金钻体系密钥信息为空");
				throw new XLRuntimeException("金钻体系密钥信息为空");
			}		
			PrivateKey query = new PrivateKey();
            query.setBizNo(key.getBizNo());
            PrivateKey myprivatekey = baseSo.findObject(query);
            if(myprivatekey != null){
            	logger.info("该业务编号已经存在");
				throw new XLRuntimeException("该业务编号已经存在");
            }
            key.setPrivateKey(UUID.randomUUID().toString());
            key.setInputTime(now());
            key.setInputBy(this.currentUserLogo());
            key.setLeftMonthNum(key.getMonthNum());
			baseSo.addObject(key);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改金钻体系密钥
	 * @return
	 */
	public String edit(){
		logger.info("开始金钻体系密钥修改");
		this.authenticateEdit();//编辑权限
		PrivateKey key = findBean(PrivateKey.class, "jinzuan_privatekey");
		try{
			if(key==null){
				logger.info("金钻体系密钥为空");
				throw new XLRuntimeException("金钻体系密钥为空");
			}
			PrivateKey query = new PrivateKey();
            query.setBizNo(key.getBizNo());
            PrivateKey mykey = baseSo.findObject(query);
            if(mykey != null){
            	if(mykey.getSeqId() != key.getSeqId()){
                	logger.info("该业务编号已经存在");
    				throw new XLRuntimeException("该业务编号已经存在");
            	}
            }
			baseSo.updateObjectById(key);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
}
