package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.Present;
import com.xunlei.niux.data.jinzuan.vo.PresentType;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 金钻赠送类型处理类
 * @author lisu
 * 2014-05-20
 */
public class PresentTypeManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(PresentTypeManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static final Page page = new Page();
    private static Map<String,String> presentTypeMap;
    private static List<SelectItem> presentTypeList;
      	
	public PresentTypeManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
		page.setPageNo(1);
		page.setPageSize(1);
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	public Map<String, String> getPresentTypeMap() {
		if(presentTypeMap == null){
			initPresentTypeMap();
		}
      
		return presentTypeMap;
	}
	
	public void initPresentTypeMap(){
		 Map<String,String> tempMap=new HashMap<String,String>();
	        PresentType query=new PresentType();
	        Page mypage = new Page();
	        mypage.addOrder("inputTime", OrderType.DESC);
			List<PresentType> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,mypage);
	        if(bplist!=null){
	        	for(PresentType type:bplist){
	        		tempMap.put(type.getPresentTypeNo(), type.getPresentTypeName()); 	
				}
	        }
	        presentTypeMap=tempMap;
	}
	
	public List<SelectItem> getPresentTypeList(){
		if(presentTypeList == null){
			initPresentTypeList();
		}		
		return presentTypeList;
	}
	
	private void initPresentTypeList(){		
		PresentType query=new PresentType();
		query.setIsValid(true);//有效的赠送类型
		List<PresentType> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
		List<SelectItem> siList=new ArrayList<SelectItem>();
		for(PresentType type:bplist){
			siList.add(new SelectItem(type.getPresentTypeNo(), type.getPresentTypeName())); 	
		}
		presentTypeList = siList;
	}
	
	/**
	 * 查询金钻赠送类型
	 * @return
	 */
	public String getQueryPresentTypeList(){		
	    logger.info("开始金钻赠送类型查询");
        this.authenticateRun();//验证运行权限
        PresentType query = findBean(PresentType.class, "jinzuan_present_type");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<PresentType> list = new ArrayList<PresentType>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<PresentType> sheet = new Sheet<PresentType>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增金钻赠送类型
	 * @return
	 */
	public String add(){
		logger.info("开始金钻赠送类型信息添加");
		this.authenticateAdd();//添加权限
		PresentType type = findBean(PresentType.class, "jinzuan_present_type");
		try{
			if(type==null){
				logger.info("金钻赠送类型信息为空");
				throw new XLRuntimeException("金钻赠送类型信息为空");
			}		
			PresentType query = new PresentType();
            query.setPresentTypeNo(type.getPresentTypeNo());
            PresentType mylevel = baseSo.findObject(query);
            if(mylevel != null){
            	logger.info("该金钻赠送类型已经存在");
				throw new XLRuntimeException("该金钻赠送类型已经存在");
            }
            type.setInputTime(now());
            type.setInputBy(this.currentUserLogo());
			baseSo.addObject(type);
			initPresentTypeMap();
			initPresentTypeList();
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改金钻赠送类型
	 * @return
	 */
	public String edit(){
		logger.info("开始金钻赠送类型信息修改");
		this.authenticateEdit();//编辑权限
		PresentType type = findBean(PresentType.class, "jinzuan_present_type");
		try{
			if(type==null){
				logger.info("金钻赠送类型信息为空");
				throw new XLRuntimeException("金钻赠送类型信息为空");
			}
			PresentType query = new PresentType();
            query.setPresentTypeNo(type.getPresentTypeNo());
            PresentType myprice = baseSo.findObject(query);
            if(myprice != null){
            	if(myprice.getSeqId() != type.getSeqId()){
                	logger.info("该金钻赠送类型已经存在");
    				throw new XLRuntimeException("该金钻赠送类型已经存在");
            	}
            }
            type.setEditTime(now());
            type.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(type);		
			initPresentTypeMap();
			initPresentTypeList();
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除金钻赠送类型
	 * @return
	 */
	public String delete(){
		logger.info("开始金钻赠送类型信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");				
		try{			
			String ids[] = delseqids.split(",");
			 Present query = new Present();
			for(String id:ids){
				 PresentType type = baseSo.findById(PresentType.class, id);				
				 query.setPtype(type.getPresentTypeNo());
				 List<Present> plist = baseSo.findObjects(query, page);
				 if(plist != null&& plist.size()>0){
					 throw new XLRuntimeException("编号为："+type.getPresentTypeNo()+"的金钻赠送类型已经被引用，无法删除");
				 }
				 baseSo.deleteById(PresentType.class, id);
			}			   
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
