package com.xunlei.niux.manager.web.model.jinzuan;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.manager.web.dto.PayOrderVoucherDTO;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.*;

public class PayOrderVoucherManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(PayOrderVoucherManagedBean.class.getName());

	public String getQueryData(){
        this.authenticateRun();//验证运行权限
       String userName = findParameter("payordervoucher_userName");
        String userIdStr = findParameter("payorder_userId");
        String orderId = findParameter("payordervoucher_orderId");
        String cashNo = findParameter("payordervoucher_cashNo");
        String parValueStr = findParameter("payordervoucher_parValue");
        String startOrderTime = findParameter("payordervoucher_beginday");
        String endOrderTime = findParameter("payordervoucher_endday");

        List<Object> params = new ArrayList<Object>();
        StringBuilder sqlWhere = new StringBuilder();
        if(StringUtils.isNotEmpty(userName)){
            sqlWhere.append(" and p.userName=?");
            params.add(userName);
        }
        if(StringUtils.isNotEmpty(userIdStr)){
            sqlWhere.append(" and p.userId=?");
            params.add(Long.valueOf(userIdStr));
        }
        if(StringUtils.isNotEmpty(orderId)){
            sqlWhere.append(" and p.orderId=?");
            params.add(orderId);
        }
        if(StringUtils.isNotEmpty(cashNo)){
            sqlWhere.append(" and v.cashNo=?");
            params.add(cashNo);
        }
        if(StringUtils.isNotEmpty(parValueStr)){
            sqlWhere.append(" and v.parValue=?");
            params.add(Integer.valueOf(parValueStr));
        }

        if(StringUtils.isNotEmpty(startOrderTime)){
            sqlWhere.append(" and p.orderTime>=?");
            params.add(startOrderTime);
        }

        if(StringUtils.isNotEmpty(endOrderTime)){
            sqlWhere.append(" and p.orderTime<=?");
            params.add(endOrderTime);
        }


        PagedFliper pagedFliper = this.getFliper();

        String sqlCnt = "SELECT count(1) FROM jinzuan_payorder p \n" +
                "right JOIN jinzuan_payorder_voucher v ON p.orderid=v.orderid where 1=1 ";


        StringBuilder sqlCntSb = new StringBuilder();
        sqlCntSb.append(sqlCnt).append(sqlWhere);

        int count = FacadeFactory.INSTANCE.getBaseSo().count(sqlCntSb.toString(),params.toArray());

        List<PayOrderVoucherDTO> list = new ArrayList<PayOrderVoucherDTO>();
        if (count > 0) {
            String sqlQuery = "SELECT p.orderid, p.userName, p.userId, v.cashNo, v.parValue, p.orderStatus, p.orderTime FROM jinzuan_payorder p \n" +
                    "right JOIN jinzuan_payorder_voucher v ON p.orderid=v.orderid where 1=1 ";
            StringBuilder sqlQuerySb = new StringBuilder();
            sqlQuerySb.append(sqlQuery).append(sqlWhere);
            sqlQuerySb.append(" order by p.orderTime desc ");
            sqlQuerySb.append(" limit ?,?");
            params.add((pagedFliper.getPageNo()-1)*pagedFliper.getPageSize());
            params.add(pagedFliper.getPageSize());
            list = FacadeFactory.INSTANCE.getBaseSo().executeQuery(PayOrderVoucherDTO.class, sqlQuerySb.toString(),params);
        }
        Sheet<PayOrderVoucherDTO> sheet = new Sheet<PayOrderVoucherDTO>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	

}
