package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.MemberDetail;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 金钻用户明细处理类
 * @author lisu
 * 2014-04-03
 */
public class MemberDetailManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(MemberDetailManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public MemberDetailManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询金钻用户明细
	 * @return
	 */
	public String getQueryMemberDetailList(){		
	    logger.info("开始金钻用户明细查询");
        this.authenticateRun();//验证运行权限
        MemberDetail query = findBean(MemberDetail.class, "jinzuan_memberdetail");
        PagedFliper pagedFliper = this.getFliper();    
        if(query != null){
        	if(query.getUserId() != null&&query.getUserId()==0){
        		query.setUserId(null);
        	}
        }
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<MemberDetail> list = new ArrayList<MemberDetail>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("orderTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<MemberDetail> sheet = new Sheet<MemberDetail>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	

}
