package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.Level;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 成长体系等级处理类
 * @author lisu
 * 2014-02-27
 */
public class LevelManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(LevelManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public LevelManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询成长体系等级
	 * @return
	 */
	public String getQueryLevelList(){		
	    logger.info("开始成长体系等级查询");
        this.authenticateRun();//验证运行权限
        Level query = findBean(Level.class, "jinzuan_level");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<Level> list = new ArrayList<Level>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("levelNum", OrderType.ESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<Level> sheet = new Sheet<Level>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增成长体系等级
	 * @return
	 */
	public String add(){
		logger.info("开始成长体系等级信息添加");
		this.authenticateAdd();//添加权限
		Level level = findBean(Level.class, "jinzuan_level");	
		try{
			if(level==null){
				logger.info("成长体系等级信息为空");
				throw new XLRuntimeException("成长体系等级信息为空");
			}		
            Level query = new Level();
            query.setLevelNum(level.getLevelNum());
            Level mylevel = baseSo.findObject(query);
            if(mylevel != null){
            	logger.info("该等级已经存在");
				throw new XLRuntimeException("该等级已经存在");
            }
			level.setInputTime(now());
			level.setInputBy(this.currentUserLogo());
			baseSo.addObject(level);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改成长体系等级信息
	 * @return
	 */
	public String edit(){
		logger.info("开始成长体系等级信息修改");
		this.authenticateEdit();//编辑权限
		Level level = findBean(Level.class, "jinzuan_level");	
		try{
			if(level==null){
				logger.info("成长体系等级信息为空");
				throw new XLRuntimeException("成长体系等级信息为空");
			}
			Level query = new Level();
            query.setLevelNum(level.getLevelNum());
            Level mylevel = baseSo.findObject(query);
            if(mylevel != null){
            	if(mylevel.getSeqId() != level.getSeqId()){
                	logger.info("该等级已经存在");
    				throw new XLRuntimeException("该等级已经存在");
            	}
            }
            level.setEditTime(now());
			level.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(level);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除成长体系等级信息
	 * @return
	 */
	public String delete(){
		logger.info("开始成长体系等级信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
			    baseSo.deleteById(Level.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
