package com.xunlei.niux.manager.web.model.jinzuan;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.pay.bo.BaseSo;
import com.xunlei.niux.data.pay.facade.FacadeFactory;
import com.xunlei.niux.data.pay.facade.IFacade;
import com.xunlei.niux.data.pay.vo.OrderCallBack;
import com.xunlei.niux.data.pay.vo.PayDetailOK;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class GrowValueManagedBean extends BaseManagedBean
{
    private static final Logger logger = Logger.getLogger(GrowValueManagedBean.class.getName());
    private static final String jinzuanurl = "http://jinzuan.niu.xunlei.com:9090/grow/use.do?";
    private static final String jinzuankey = "94eea20d-7b37-4021-8edf-0cea8e6cb342";
    private BaseSo baseSo;
    private int rownum = 0;
    private static final String ptype = "3";

    public GrowValueManagedBean()
    {
        this.baseSo = FacadeFactory.INSTANCE.getBaseSo();

        int pageNo = getFliper().getPageNo();
        int pageSize = getFliper().getPageSize();
        this.rownum = (this.rownum + (pageNo - 1) * pageSize + 1);
    }

    public int getRownum() {
        return this.rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    public String getQueryGrowValueList()
    {
        logger.info("开始成长值查询");
        String orderId = findParameter("growvalue_orderid");
        OrderCallBack query = new OrderCallBack();
        if (StringTools.isNotEmpty(orderId)) {
            query.setOrderid(orderId);
        }
        query.setNoticeJinZuan(Boolean.valueOf(false));
        PagedFliper pagedFliper = getFliper();
        int count = this.baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List list = new ArrayList();
        if (count > 0) {
            this.rownum = 1;
            Page page = new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("optime", OrderType.DESC);
            list = this.baseSo.findObjects(query, page);
        }
        Sheet sheet = new Sheet(count, list);
        mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
        return "";
    }

    public String repair()
    {
        logger.info("开始成长值补发");
        String orderId = findParameter("one_aporderid");
        try {
            if (StringTools.isEmpty(orderId)) {
                logger.info("成长值信息为空");
                throw new XLRuntimeException("成长值信息为空");
            }
            OrderCallBack query = new OrderCallBack();
            query.setOrderid(orderId);
            OrderCallBack ocb = (OrderCallBack)this.baseSo.findObject(query);
            if (ocb == null) {
                logger.info("成长值信息不存在");
                throw new XLRuntimeException("成长值信息不存在");
            }
            repairGrowValue(ocb);
            ocb.setEditBy(currentUserLogo());
            ocb.setEditTime(now());
            this.baseSo.updateObjectById(ocb);
        } catch (Exception e) {
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    private void repairGrowValue(OrderCallBack ocb) {
        String orderId = ocb.getOrderid();
        PayDetailOK query = new PayDetailOK();
        query.setOrderid(orderId);
        PayDetailOK pdo = (PayDetailOK)this.baseSo.findObject(query);
        if (pdo == null) return;
        noticeJinZuan(pdo, ocb);
    }

    public void noticeJinZuan(PayDetailOK paydetailok, OrderCallBack ocb)
    {
        long timestamp = System.currentTimeMillis() / 1000L;
        String uid = paydetailok.getToinneruserid();
        String msg = uid + "3" + timestamp + "94eea20d-7b37-4021-8edf-0cea8e6cb342";
        String sign = Md5Encrypt.md5(msg);
        StringBuffer url = new StringBuffer("http://jinzuan.niu.xunlei.com:9090/grow/use.do?").append("uid=").append(uid)
                .append("&timestamp=").append(timestamp).append("&ptype=3").append("&money=")
                .append(paydetailok.getTotalmoney()).append("&sign=").append(sign);
        logger.info("noticejinzuan orderid=" + paydetailok.getOrderid() + ",uid=" + uid + ",url:" + url);
        String responseText = HttpClientUtil.getInfoForHttpGetMothed(url.toString());
        logger.info("noticejinzuan orderid=" + paydetailok.getOrderid() + ",uid=" + uid + ",responseText:" + responseText);
        try {
            JSONObject data = new JSONObject(responseText);
            String rtn = data.getString("rtn");
            if ("0".equals(rtn))
                ocb.setNoticeJinZuan(Boolean.valueOf(true));
            else
                ocb.setCode(rtn);
        }
        catch (JSONException e) {
            e.printStackTrace();
            logger.info("noticejinzuan error orderid=" + paydetailok.getOrderid() + ",uid=" + uid + ",reason:" + e.getMessage());
        }
    }
}