package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.GrowRule;
import com.xunlei.niux.data.jinzuan.vo.Level;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 成长值规则处理类
 * @author lisu
 * 2014-04-03
 */
public class GrowRuleManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(GrowRuleManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public GrowRuleManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询成长值规则
	 * @return
	 */
	public String getQueryGrowRuleList(){		
	    logger.info("开始成长值规则查询");
        this.authenticateRun();//验证运行权限
        GrowRule query = findBean(GrowRule.class, "jinzuan_growrule");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<GrowRule> list = new ArrayList<GrowRule>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.addOrder("growType", OrderType.DESC);
        	page.addOrder("isannual", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<GrowRule> sheet = new Sheet<GrowRule>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增成长值规则
	 * @return
	 */
	public String add(){
		logger.info("开始成长值规则添加");
		this.authenticateAdd();//添加权限
		 GrowRule grow = findBean(GrowRule.class, "jinzuan_growrule");
		try{
			if(grow==null){
				logger.info("成长值规则为空");
				throw new XLRuntimeException("成长值规则为空");
			}		
			grow.setInputBy(this.currentUserLogo());
			grow.setInputTime(now());
			baseSo.addObject(grow);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改成长值规则
	 * @return
	 */
	public String edit(){
		logger.info("开始成长值规则修改");
		this.authenticateEdit();//编辑权限
		 GrowRule grow = findBean(GrowRule.class, "jinzuan_growrule");
		try{
			if(grow==null){
				logger.info("成长值规则为空");
				throw new XLRuntimeException("成长值规则为空");
			}
			grow.setEditTime(now());
			grow.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(grow);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除成长值规则
	 * @return
	 */
	public String delete(){
		logger.info("开始成长值规则删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
			    baseSo.deleteById(Level.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
