package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.CodeUseError;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 激活码输入错误处理类
 * @author lisu
 * 2014-05-29
 */
public class CodeUseErrorManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CodeUseErrorManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public CodeUseErrorManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询激活码输入错误
	 * @return
	 */
	public String getQueryCodeUseErrorList(){		
	    logger.info("开始激活码输入错误查询");
        this.authenticateRun();//验证运行权限
        CodeUseError query = findBean(CodeUseError.class, "jinzuan_code_use_error");
        if(query != null){
        	if(query.getUserId()!=null&&query.getUserId().longValue()==0){
        		query.setUserId(null);
        	}
        }
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<CodeUseError> list = new ArrayList<CodeUseError>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("daytime", OrderType.DESC);
        	page.addOrder("errorCount", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<CodeUseError> sheet = new Sheet<CodeUseError>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
}
